package cn.com.duiba.developer.center.api.utils;

import org.apache.commons.lang.StringUtils;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ParamEstimateUtils {
	private static Map<String,String> emailMap = new HashMap<String,String>();
	static{
		emailMap.put("qq.com", "http://mail.qq.com");
		emailMap.put("gmail.com","http://mail.google.com");
		emailMap.put("sina.com","http://mail.sina.com.cn");
		emailMap.put("163.com","http://mail.163.com");
		emailMap.put("126.com","http://mail.126.com");
		emailMap.put("yeah.net","http://www.yeah.net");
		emailMap.put("sohu.com","http://mail.sohu.com");
		emailMap.put("tom.com","http://mail.tom.com");
		emailMap.put("sogou.com","http://mail.sogou.com");
		emailMap.put("139.com","http://mail.10086.cn");
		emailMap.put("hotmail.com","http://www.hotmail.com");
		emailMap.put("live.com","http://login.live.com");
		emailMap.put("live.cn","http://login.live.cn");
		emailMap.put("live.com.cn","http://login.live.com.cn");
		emailMap.put("189.com","http://webmail16.189.cn/webmail");
		emailMap.put("yahoo.com.cn","http://mail.cn.yahoo.com");
		emailMap.put("yahoo.cn","http://mail.cn.yahoo.com");
		emailMap.put("eyou.com","http://www.eyou.com");
		emailMap.put("21cn.com","http://mail.21cn.com");
		emailMap.put("188.com","http://www.188.com");
		emailMap.put("foxmail.coom","http://www.foxmail.com");
	}
	
	public static String getEmailIndexURL(String email){
		if(!isEmail(email)){
			return null;
		}
		String temp = email.substring(email.indexOf("@")+1);
		return emailMap.get(temp);
	}
	/**
	 * 验证字段中是否存在非法SQL注入内容
	 * @param p
	 * @return
	 */
	public static boolean isValid(String p) {
		if(p==null){
			return true;
		}
		p = p.toUpperCase();
	
		if (p.indexOf("DELETE") >= 0 || p.indexOf("ASCII") >= 0
			|| p.indexOf("UPDATE") >= 0 || p.indexOf("SELECT") >= 0
			|| p.indexOf("'") >= 0 || p.indexOf("SUBSTR(") >= 0
			|| p.indexOf("COUNT(") >= 0 || p.indexOf(" OR ") >= 0
			|| p.indexOf(" AND ") >= 0 || p.indexOf("DROP") >= 0
			|| p.indexOf("EXECUTE") >= 0 || p.indexOf("EXEC") >= 0
			|| p.indexOf("TRUNCATE") >= 0 || p.indexOf("INTO") >= 0
			|| p.indexOf("DECLARE") >= 0 || p.indexOf("MASTER") >= 0
			|| p.indexOf("%")>=0
			) {
			return false;
		}
		return true;
	}
	
	/**
	 * 检测邮箱地址是否合法
	 * @param email
	 * @return true合法 false不合法
	 */
	public static boolean isEmail(String email){
		if (null==email || "".equals(email)) return false;
		Pattern p =  Pattern.compile("\\w+([-+.]\\w+)*@\\w+([-.]\\w+)*\\.\\w+([-.]\\w+)*");//复杂匹配
		Matcher m = p.matcher(email);
		return m.matches();
	}
	
	/**
	 * 验证手机号码是否合法
	 * @param phone
	 * @return true 合法 false 不合法
	 */
	public static boolean isPhone(String phone){
		if(StringUtils.isEmpty(phone)){
			return false;
		}
		if (phone.length()!=11){
			return false;
		}
		Pattern p = Pattern.compile("[0-9]*");
		Matcher m = p.matcher(phone);
		return m.matches();
	}
	
}
