package cn.com.duiba.developer.center.api.domain.enums;

import org.apache.commons.lang.StringUtils;

/**
 * 新兑吧计划任务状态
 * @Author【yaocheng@duiba.com.cn】
 * @Date 2016/11/9 20:58
 */
public enum DuibaTaskStatusEnum implements EnumInterface{

    OPEN("OPEN", "开启"),

    CLOSE("CLOSED", "关闭");

    /** 代码 */
    private String code;

    /** 描述 */
    private String desc;

    private DuibaTaskStatusEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static DuibaTaskStatusEnum getByCode(String code) {
        for (DuibaTaskStatusEnum enumVal : DuibaTaskStatusEnum.values()) {
            if (StringUtils.equals(code, enumVal.getCode())) {
                return enumVal;
            }
        }
        return null;
    }

    @Override
    public String getCode() {
        return code;
    }

    @Override
    public String getDesc() {
        return desc;
    }
}
