/**
 * Project Name:developer-center-api File Name:ActivityFloorConfKeyEnum.java Package
 * Name:cn.com.duiba.developer.center.api.domain.enums.floor Date:2016年8月22日下午1:39:52 Copyright (c) 2016, duiba.com.cn
 * All Rights Reserved.
 */

package cn.com.duiba.developer.center.api.domain.enums.floor;

import org.apache.commons.lang.StringUtils;

import cn.com.duiba.developer.center.api.domain.enums.EnumInterface;

/**
 * ClassName:ActivityFloorConfKeyEnum <br/>
 * 活动子页面楼层配置项枚举. <br/>
 * Date: 2016年8月22日 下午1:39:52 <br/>
 * 
 * @author zhanglihui
 * @version
 * @since JDK 1.6
 * @see
 */
public enum ActivityFloorConfKeyEnum implements EnumInterface {
    /** 楼层标题 */
    FLOOR_TITLE("floorTitle", "楼层标题"),

    /** 点击后跳转目标 {@see ChildPageTargetEnum} */
    TARGET("target", "点击后跳转目标"),

    /** 是否展示活动积分 */
    SHOW_CREDITS("showCredits", "是否展示活动积分"),

    /** 是否展示活动标题 */
    SHOW_TITLE("showTitle", "是否展示活动标题"),

    /** 是否展示角标 */
    SHOW_CUSTOM_TAG("showCustomTag", "是否展示角标");

    /** 代码 */
    private String code;

    /** 描述 */
    private String desc;

    private ActivityFloorConfKeyEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static ActivityFloorConfKeyEnum getByCode(String code) {
        for (ActivityFloorConfKeyEnum enumVal : ActivityFloorConfKeyEnum.values()) {
            if (StringUtils.equals(code, enumVal.getCode())) {
                return enumVal;
            }
        }
        return null;
    }

    @Override
    public String getCode() {
        return code;
    }

    @Override
    public String getDesc() {
        return desc;
    }
}
