/**
 * Project Name:developer-center-api File Name:SnapUpFloorConfKeyEnum.java Package
 * Name:cn.com.duiba.developer.center.api.domain.enums.floor Date:2016年8月22日下午1:48:07 Copyright (c) 2016, duiba.com.cn
 * All Rights Reserved.
 */

package cn.com.duiba.developer.center.api.domain.enums.floor;

import org.apache.commons.lang.StringUtils;

import cn.com.duiba.developer.center.api.domain.enums.EnumInterface;

/**
 * ClassName:SnapUpFloorConfKeyEnum <br/>
 * 今日必抢子页面楼层配置项枚举. <br/>
 * Date: 2016年8月22日 下午1:48:07 <br/>
 * 
 * @author zhanglihui
 * @version
 * @since JDK 1.6
 * @see
 */
public enum SnapUpFloorConfKeyEnum implements EnumInterface {

    /** 楼层图标 */
    FLOOR_IMG("floorImg", "楼层图标"),

    /** 展示数量 */
    SHOW_NUM("showNum", "展示数量");

    /** 代码 */
    private String code;

    /** 描述 */
    private String desc;

    private SnapUpFloorConfKeyEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static SnapUpFloorConfKeyEnum getByCode(String code) {
        for (SnapUpFloorConfKeyEnum enumVal : SnapUpFloorConfKeyEnum.values()) {
            if (StringUtils.equals(code, enumVal.getCode())) {
                return enumVal;
            }
        }
        return null;
    }

    @Override
    public String getCode() {
        return code;
    }

    @Override
    public String getDesc() {
        return desc;
    }
}
