package cn.com.duiba.developer.center.api.remoteservice;

import cn.com.duiba.developer.center.api.domain.dto.AerosolDto;
import cn.com.duiba.developer.center.api.domain.dto.AerosolGroupDto;
import cn.com.duiba.developer.center.api.domain.paramquery.AppAerosolParams;
import cn.com.duiba.developer.center.api.domain.paramquery.PageQueryEntity;
import cn.com.duiba.developer.center.api.domain.vo.PaginationVO;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;
import java.util.Set;

/**
 * 浮标服务
 */
public interface RemoteAerosolService {


    /**
     * 获取浮标编组列表首页
     * @return
     */
    DubboResult<List<AerosolGroupDto>> loadAerosolGroup();

    /**
     * 获取浮标配置
     * @param appId 用户的appId
     * @return AerosolDto
     */
    DubboResult<AerosolDto> loadAerosolConfig(Long appId);

    /**
     * 获取浮标配置
     * @param appId 用户的appId
     * @return AerosolDto
     */
    DubboResult<AerosolDto> loadAerosolNoCache(Long appId);

    /**
     * 根据groupId获取浮标组
     * @return
     */
    DubboResult<AerosolGroupDto> getAerosolGroupById(Long groupId);
    /**
     *  创建浮标分组
     * @param group
     * @return
     */
    DubboResult<Long> createAerosolGroup(AerosolGroupDto group);
    /**
     * 编辑浮标组的配置
     * @param aerosolGroupDto
     * @return
     */
    DubboResult<Boolean> updateGroupConfig(AerosolGroupDto aerosolGroupDto);
    /**
     * 更改浮标组的开关状态
     * @param groupId
     * @return 修改后的状态
     */
    DubboResult<Boolean> updateAerosolGroupShowStatus(Long groupId);
    /**
     * 删除分组
     * @param groupId
     * @return
     */
    DubboResult<Boolean> deleteAerosolGroup(Long groupId);



    /**
     * 创建单个App浮标
     * @param config
     * @return
     */
    DubboResult<Boolean> createAerosol(AerosolDto config);
    /**
     * 更改浮标的开关状态(App处于归组状态,此接口不许调用)
     * @param appId
     * @return 修改后的状态
     */
    DubboResult<Boolean> updateAerosolShowStatus(Long appId);

    /**
     * 更改浮标的配置
     * @param config
     * @return
     */
    DubboResult<Boolean> updateAerosol(AerosolDto config);
    /**
     * 获取浮标列表
     * @return
     */
    DubboResult<PaginationVO<AerosolDto>> loadAerosolList(AppAerosolParams params);

    /**
     * 根据给定的appId批量查询浮标信息
     * @param appIds
     * @return
     */
    DubboResult<List<AerosolDto>> loadAerosolByAppIds(Set<Long> appIds);
    /**
     * 归组操作
     * @param groupId
     * @param appId
     * @return
     */
    DubboResult<Boolean> addToGroup(Long groupId,Long appId);

    /**
     * 批量添加app归组
     * @param groupId
     * @param appIds
     * @return
     */
    DubboResult<Boolean> batchAddToGroup(Long groupId,Set<Long> appIds);
    /**
     * App从组中移除
     * @param appId
     * @return
     */
    DubboResult<Boolean> delForGroup(Long appId);

    /**
     * 批量同步
     * @param groupId
     * @param igenoreIds
     * @return
     */
    DubboResult<Boolean> synAerosolGroup(Long groupId,Set<Long> igenoreIds);

    /**
     * 批量删除
     * @param groupId
     * @param igenoreIds
     * @return
     */
    DubboResult<Boolean> delAerosolByGroupId(Long groupId,Set<Long> igenoreIds);

    /**
     * 删除单个App浮标
     * @param appId appId
     * @return 删除是否成功
     */
    DubboResult<Boolean> delAerosolByAppId(Long appId);

    /**
     * 根据groupId获取浮标app列表
     * @param groupId 组Id
     * @return
     */
    DubboResult<List<AerosolDto>> loadGroupAppList(Long groupId);

}
