/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.developer.center.api.utils;

import cn.com.duiba.developer.center.api.DeveloperCenterException;
import cn.com.duiba.developer.center.api.utils.DBcongfigFileContext;
import com.google.common.base.Charsets;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.io.CharSource;
import com.google.common.io.Resources;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class DBcongfigAnalytic {
    private static final String OSS_CONFIG_PATH = "duibaFloorCofig/";
    public static final String FILE_TYPE = ".duibaconfig";

    private DBcongfigAnalytic() {
    }

    public static DBcongfigFileContext parse(String fileUrl) throws DeveloperCenterException {
        DBcongfigFileContext context = new DBcongfigFileContext();
        if (StringUtils.isBlank((String)fileUrl) || !fileUrl.endsWith(FILE_TYPE)) {
            return context;
        }
        try {
            URL url = new URL(fileUrl);
            CharSource source = Resources.asCharSource((URL)url, (Charset)Charsets.UTF_8);
            ImmutableList lines = source.readLines();
            for (String line : lines) {
                context.addLine(line);
            }
            return context;
        }
        catch (Exception e) {
            throw new DeveloperCenterException(e);
        }
    }

    public static DBcongfigFileContext parseContext(String context) {
        Splitter spl = Splitter.on((String)"\n").omitEmptyStrings();
        List lines = spl.splitToList((CharSequence)context);
        DBcongfigFileContext fileContext = new DBcongfigFileContext();
        for (String line : lines) {
            fileContext.addLine(line);
        }
        return fileContext;
    }

    public static String getOssConfigPath(String fileName) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(OSS_CONFIG_PATH);
        stringBuilder.append(fileName).append("-").append(new Date().getTime());
        stringBuilder.append(FILE_TYPE);
        return stringBuilder.toString();
    }
}

