/**
 * Project Name:developer-center-api File Name:RemoteAppBannerService.java Package
 * Name:cn.com.duiba.developer.center.api.remoteservice Date:2016年8月10日下午8:04:14 Copyright (c) 2016, duiba.com.cn All
 * Rights Reserved.
 */

package cn.com.duiba.developer.center.api.remoteservice;

import java.util.List;

import cn.com.duiba.developer.center.api.domain.dto.AppBannerDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * ClassName:RemoteAppBannerService <br/>
 * appBanner dubbo服务接口
 * Date: 2016年8月10日 下午8:04:14 <br/>
 * 
 * @author zhanglihui
 * @version
 * @since JDK 1.6
 * @see
 */
public interface RemoteAppBannerServiceNew {

    /**
     * 获取的banner和Icon区的AppBannerDto列表
     * @param appId
     * @return
     */
    DubboResult<List<AppBannerDto>> findHomeBannerByCache(Long appId);
    /**
     * 根据id查询banner对象
     *
     * @author zhanglihui
     * @param id banner主键
     * @return
     * @since JDK 1.6
     */
    DubboResult<AppBannerDto> find(Long id);

    /**
     * 根据主键和appId更新appBanner
     * 所有的写操作都需要带上appId，防止未授权操作
     *
     * @author zhanglihui
     * @param appBanner banner对象
     * @return
     * @since JDK 1.6
     */
    DubboResult<Integer> updateByIdAndAppId(AppBannerDto appBanner);

    /**
     * 根据主键和appId更新appBanner,允许更新活动时间为null
     * 所有的写操作都需要带上appId，防止未授权操作
     *
     * @author zhanglihui
     * @param appBanner banner对象
     * @return
     * @since JDK 1.6
     */
    DubboResult<Integer> updateByIdAndAppIdWithActivityDateNull(AppBannerDto appBanner);

    /**
     * 新增banner
     *
     * @author zhanglihui
     * @param appBanner banner对象
     * @return
     * @since JDK 1.6
     */
    DubboResult<Void> insert(AppBannerDto appBanner);

    /**
     * 根据appId和类型查询当前最大payload值
     *
     * @author zhanglihui
     * @param appId app编号
     * @param type  类型 {@link cn.com.duiba.developer.center.api.domain.enums.BannerOrButtonEnum}
     * @return
     * @since JDK 1.6
     */
    DubboResult<Integer> findMaxPlayload(Long appId, String type);

    /**
     * 根据appId和deleted标志查询banner列表
     *
     * @author zhanglihui
     * @param appId app编号
     * @param deleted 是否删除标志
     * @return
     * @since JDK 1.6
     */
    DubboResult<List<AppBannerDto>> findAllByAppId(Long appId, Boolean deleted);

    /**
     * 根据appId、type和deleted标志查询banner列表
     *
     * @author zhanglihui
     * @param appId   app编号
     * @param type    类型 {@link cn.com.duiba.developer.center.api.domain.enums.BannerOrButtonEnum}
     * @param deleted 是否删除
     * @return
     * @since JDK 1.6
     */
    DubboResult<List<AppBannerDto>> findAllByAppIdDeleteAndType(Long appId, String type, Boolean deleted);

    /**
     * sortByBannerIdAndRange:在banner移动范围内排序 <br/>
     * 排序区间为闭区间[startPayload, endPayload]
     * 
     * @author zhanglihui
     * @param appId app编号
     * @param bannerId banner编号
     * @param type 类型 banner/button
     * @param startPayload 排序起始payload值
     * @param endPayload 排序结束payload值
     * @return
     * @since JDK 1.6
     */
    DubboResult<Void> sortByBannerIdAndRange(Long appId, Long bannerId, String type, Integer startPayload,
                                             Integer endPayload);
    
    /**
     * 
     * 根据appItemId查询banner列表（包含已删除的）
     *
     * @author zhanglihui
     * @param appId     app编号
     * @param appItemId 开发者商品id
     * @param type      类型 {@link cn.com.duiba.developer.center.api.domain.enums.BannerOrButtonEnum}
     * @return
     * @since JDK 1.6
     */
    DubboResult<List<AppBannerDto>> findBannerByItemId(Long appId, Long appItemId, String type);
}
