package cn.com.duiba.developer.center.api.remoteservice;

import cn.com.duiba.developer.center.api.domain.dto.appextra.DuibaShareDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * Created by liuyao on 2016/10/12.
 */
public interface RemoteAppExtraService {
    /**
     * 加积分接口
     * @param appId
     * @return
     */
    DubboResult<String> findAppAddCreditsUrlByAppId(Long appId);

    /**
     * 获取唤起登录代码
     * @param appId
     * @return
     */
    DubboResult<String> findCallLoginProgramByAppId(Long appId);

    /**
     * 查询对吧分享信息
     * @param appId
     * @return
     */
    DubboResult<DuibaShareDto> findDuibaShareByAppId(Long appId);
    
    /**
     * 查询是否分享
     * updateIsActivityShare:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param appId
     * @param isActivityShare
     * @since JDK 1.6
     */
    void updateIsActivityShare(Long appId, Boolean isActivityShare);
    
    /**
     * 查询分享代码
     * findShareProgramByAppId:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @author liyang
     * @param appId
     * @return
     * @since JDK 1.6
     */
    DubboResult<String> findShareProgramByAppId(Long appId);

    /**
     * 获取告警电话
     * @param appId
     * @return
     */
    DubboResult<String> findAlarmPhone(Long appId);
}
