package cn.com.duiba.developer.center.api.domain.enums;

import com.google.common.collect.Maps;

import java.util.Map;

/**
 * Created by liuyao on 2017/3/10.
 * 浮标指向页枚举
 */
public enum PageEnum {
    ALL(0,"全局页面"),
    MAIN_MEET(1,"主会场"),
    SUB_PAGE(2,"楼层子页面"),
    HOME(3,"楼层首页"),
    HD_TOOL(4,"活动工具"),
    SECKILL_SUBJECT(5,"秒杀专题"),
    QUESTION_ANSWER(6,"答题活动"),
    QUIZZ(7,"测试题"),
    GAME(8,"游戏"),
    GUESS(9,"竞猜活动"),
    ROB(10,"今日必抢"),
    PLUGIN(11,"弹层插件"),
    LITTLE_GAME(12,"小游戏"),
    CREDITS_GAME(13,"积分游戏"),
    CUSTOM(14,"自定义");

    private static Map<Integer,PageEnum> PAGE_MAP = Maps.newHashMap();
    static {
        for(PageEnum page:PageEnum.values()){
            PAGE_MAP.put(page.getCode(),page);
        }
    }

    private Integer code;
    private String name;

    private PageEnum(Integer code,String name){
        this.code = code;
        this.name = name;
    }

    public static PageEnum getPageByCode(Integer code){
        return PAGE_MAP.get(code);
    }

    public Integer getCode() {
        return code;
    }

    public String getName() {
        return name;
    }
}
