package cn.com.duiba.developer.center.api.remoteservice;

import java.util.List;
import java.util.Map;

import cn.com.duiba.developer.center.api.domain.dto.AmbExpressTemplateDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * 加钱购模板服务
 */
public interface RemoteExpressTemplateService {
	 /**
     * 根据id查询
     * @param id
     * @return
     */
    public DubboResult<AmbExpressTemplateDto> find(Long id);

    /**
     * 新增记录
     * @param entity
     * @return
     */
    public DubboResult<Boolean> insert(AmbExpressTemplateDto entity);

    /**
     * 更新记录
     * @param entity
     * @return
     */
    public DubboResult<Integer> update(AmbExpressTemplateDto entity);

    /**
     * 获取模板分页列表
     * @param params
     * @return
     */
    public DubboResult<List<AmbExpressTemplateDto>> findPageList(Map<String, Object> params);

    /**
     * 获取模板分页总数
     * @param params
     * @return
     */
    public DubboResult<Long> findPageCount(Map<String, Object> params);

    /**
     * 删除模板
     * @param id
     * @return
     */
    public DubboResult<Boolean> deleteTemplateById(Long id);

    /**
     * @param appId
     * @param type
     * @return
     */
    public DubboResult<List<AmbExpressTemplateDto>> findByAppIdAndType(Long appId, String type);

    /**
     * @param appId
     * @param name
     * @return
     */
    public DubboResult<AmbExpressTemplateDto> findByAppIdAndName(Long appId, String name);
}
