package cn.com.duiba.developer.center.api.domain.enums;

/**
 * CenterConfig的所有键值
 */
public enum CenterConfigEnum {
    TYPE_MAINMEET_PLACE("main_meeting_place"),	// 主会场开关

    TYPE_MAINMEET_RESOURCE("main_meeting_resource"),// 主会场图片和链接

    TYPE_MAINMEET_CODE_BOX("main_meeting_code_box"),// 主会场代码编辑框

    TYPE_PHONEBILL_SESSION("phonebill_session"),

    TYPE_LIANLIAN_PHONEBILL_SWITCH("lianlian-phonebill-switch"),

    TYPE_LIULIANGGO_PHONEBILL_SWITCH("liulianggo-phonebill-switch"),

    TYPE_SUDUDA_PHONEBILL_SWITCH("sududa-phonebill-switch"),

    TYPE_GYJX_PHONEBILL_SWITCH("gyjx-phonebill-switch"),

    TYPE_OUFEI_PHONEBILL_SWITCH("oufei-phonebill-switch"),

    TYPE_ENLIAN_QB_SWITCH("enlian-qb-switch"),

    TYPE_GOUKA_QB_SWITCH("gouka-qb-switch"),

    TYPE_TENCENT_QB_SWICTH("tencent-qb-switch"),

    TYPE_ALIPAY_CODE_RATE("alipaycode-rate"),// 支付码费率，
    // 最终收费=面值*费率
    TYPE_ALIPAY_FAST_RATE("alipayfast-rate"),// 支付码费率，
    // 最终收费=面值*费率
    TYPE_ALIPAY_RATE("alipay-rate"),// 支付宝转账费率，最终收费=面值*费率

    TYPE_ENLIAN_QB_RATE("qb-rate"),// Q币费率
    TYPE_ACTIVITY_FORESHOW("ACTIVITY_FORESHOW"),// 活动预告

    TYPE_SECOND_KILL_QUEUE_SCAN_IPS("scan-secondkill-process-ips"),//秒杀商品进入队列，此处写ip串，这些ip的服务器，启动扫描程序进行处理
    
    TYPE_CRECORD_SYS_CONFIG("CRECORD_SYS_CONFIG");//兑换结果列表推荐位样式

    private String type;

    CenterConfigEnum(String type){
        this.type = type;
    }

    public String getType() {
        return type;
    }

    /**
     * 通过类型查询枚举值
     * @param type
     * @return
     * @author xiaoxuda 2016/12/22
     */
    public static CenterConfigEnum getByType(String type){
        for(CenterConfigEnum centerConfigEnum : CenterConfigEnum.values()){
            if(centerConfigEnum.getType().equals(type)){
                return centerConfigEnum;
            }
        }
        return null;
    }
}
