package cn.com.duiba.developer.center.api.domain.enums;

import cn.com.duiba.developer.center.api.domain.dto.floorconfig.*;
import com.google.common.collect.Maps;

import java.util.Map;

/**
 * Created by liuyao on 2017/1/4.
 */
public enum FloorTypeEnum {
    Banner(1,"banner", BannerJson.class),
    ICON(2,"icon", IconJson.class),
    Goods(3,"商品区",GoodsJson.class),
    Rob(4,"今日必抢",SnapUpJson.class),
    Activity(5,"活动楼层",ActivityJson.class),
    Coupon(6,"优惠券",CouponJson.class),
    Custom(7,"自定义楼层",BaseJson.class),
    ShowCase(8,"橱窗区",BaseJson.class),
    Game(9,"游戏中心",GameJson.class),
    Seckill(10,"免单秒杀",BaseJson.class),
    Sign(11,"签到楼层",BaseJson.class);

    private static Map<Integer,FloorTypeEnum> typeMap = Maps.newHashMap();

    static{
        for(FloorTypeEnum typeClass : FloorTypeEnum.values()){
            typeMap.put(typeClass.getType(),typeClass);
        }
    }

    /**
     * 根据type获取具体枚举类型
     * @param type
     * @return
     */
    public static FloorTypeEnum getByType(Integer type){
        return typeMap.get(type);
    }

    private Integer type;
    private String name;
    private Class<? extends BaseJson> defaultConfigClass;

    public Integer getType() {
        return type;
    }

    public String getName() {
        return name;
    }

    public Class<? extends BaseJson> getDefaultConfigClass(){
        return defaultConfigClass;
    }

    FloorTypeEnum(Integer type, String name,Class<? extends BaseJson> defaultConfigClass){
        this.type = type;
        this.name = name;
        this.defaultConfigClass = defaultConfigClass;
    }


}
