package cn.com.duiba.developer.center.api.remoteservice.floor;

import java.util.Collection;
import java.util.List;

import cn.com.duiba.developer.center.api.domain.enums.FloorDataTypeEnum;
import com.alibaba.fastjson.JSONObject;

import cn.com.duiba.developer.center.api.domain.dto.CreditsFloorCodeCopyDto;
import cn.com.duiba.developer.center.api.domain.dto.CreditsFloorCodeDto;
import cn.com.duiba.developer.center.api.domain.paramquery.FloorPageParams;
import cn.com.duiba.developer.center.api.domain.vo.PaginationVO;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * Created by suyuanlong on 16/8/10.
 */
public interface RemoteCreditsFloorCodeService {
    /**
     * 创建楼层
     * @param dto
     * @return
     */
    DubboResult<CreditsFloorCodeDto> insertFloorCode(CreditsFloorCodeDto dto);

    /**
     * 更新楼层
     * @param dto
     * @return
     */
    DubboResult<Integer> updateFloorCode(CreditsFloorCodeDto dto);

    /**
     * 按类型加载楼层
     * @param params
     * @return
     */
    DubboResult<PaginationVO<JSONObject>> selectFloorCodesByType(FloorPageParams params);

    /**
     * 按数据类型加载楼层
     * @param dataTypeEnum
     * @return
     */
    DubboResult<List<CreditsFloorCodeDto>> findFloorByDataType(FloorDataTypeEnum dataTypeEnum);

    /**
     * 加载单个楼层详情
     * @param id
     * @return
     */
    DubboResult<CreditsFloorCodeDto> selectFloorCodeById(Long id);

    /**
     * 查询皮肤下所有的楼层副本
     * @param skinId
     * @return
     */
    DubboResult<List<CreditsFloorCodeCopyDto>> seletCodeCopyListBySkinId(Long skinId);

    /**
     * 批量加载皮肤楼层
     * @param ids
     * @return
     */
    DubboResult<List<CreditsFloorCodeDto>> getFloorCodeList(Collection<Long> ids);
}
