package cn.com.duiba.developer.center.api.domain.enums;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;

import java.util.List;

/**
 * Created by liuyao on 2017/3/22.
 * 楼层数据接口类型
 */
public enum FloorDataTypeEnum {

    BANNER_DEFAULT(FloorTypeEnum.Banner,0,"默认banner"),

    ICON_DEFAULT(FloorTypeEnum.ICON,0,"默认ICON"),

    GOODS_DEFAULT(FloorTypeEnum.Goods,0,"商品区"),
    GOODS_PAGE(FloorTypeEnum.Goods,1,"商品区分页"),

    ROB_DEFAULT(FloorTypeEnum.Rob,0,"单列今日必抢"),
    ROB_CLASSES(FloorTypeEnum.Rob,1,"类目今日必抢"),

    ACTIVITY_PAGE(FloorTypeEnum.Activity,0,"子页面活动"),
    ACTIVITY_GROUP(FloorTypeEnum.Activity,1,"活动组活动"),
    ACTIVITY_OPERATING(FloorTypeEnum.Activity,2,"开发者入库活动"),

    COUPON_DEFAULT(FloorTypeEnum.Coupon,0,"优惠券"),

    CUSTOM_DEFAULT(FloorTypeEnum.Custom,0,"自定义楼层"),
    CUSTOM_YAOFENG(FloorTypeEnum.Custom,1,"腰封楼层"),
    CUSTOM_TOP(FloorTypeEnum.Custom,2,"吸顶悬浮"),
    CUSTOM_BOTTOM(FloorTypeEnum.Custom,3,"底部悬浮"),

    SHOWCASE_DEFAULT(FloorTypeEnum.ShowCase,0,"默认橱窗"),

    GAME_DEFAULT(FloorTypeEnum.Game,0,"游戏中心"),

    SECKILL_DEFAULT(FloorTypeEnum.Seckill,0,"免单秒杀"),

    SIGN_DEFAULT(FloorTypeEnum.Sign,0,"普通签到");

    private static Table<FloorTypeEnum,Integer,FloorDataTypeEnum> TABLE = HashBasedTable.create();
    private static ArrayListMultimap<FloorTypeEnum,FloorDataTypeEnum> TYPE_MAP = ArrayListMultimap.create();
    static{
        for(FloorDataTypeEnum item : FloorDataTypeEnum.values()){
            TABLE.put(item.floorType,item.code,item);
            TYPE_MAP.put(item.floorType,item);
        }
    }

    private FloorTypeEnum floorType;
    private Integer code;
    private String desc;

    FloorDataTypeEnum(FloorTypeEnum floorType,Integer code,String desc){
        this.floorType = floorType;
        this.code = code;
        this.desc = desc;
    }

    /**
     * 获取的楼层数据类型
     * @param floorType
     * @param code
     * @return
     */
    public static FloorDataTypeEnum getDataType(FloorTypeEnum floorType,Integer code){
        return TABLE.get(floorType,code);
    }

    /**
     * 获取楼层类型下所有数据接口类型
     * @return
     */
    public static List<FloorDataTypeEnum> getFloorDataTypesByFloorType(FloorTypeEnum floorType){
        return TYPE_MAP.get(floorType);
    }

    public Integer getCode() {
        return code;
    }

    public FloorTypeEnum getFloorType() {
        return floorType;
    }

    public String getDesc() {
        return desc;
    }
}
