package cn.com.duiba.developer.center.api.remoteservice.floor;

import java.util.List;
import java.util.Map;
import java.util.Set;

import cn.com.duiba.developer.center.api.domain.dto.AppSimpleDto;
import com.alibaba.fastjson.JSONArray;

import cn.com.duiba.developer.center.api.domain.dto.AppLayoutBrickDto;
import cn.com.duiba.developer.center.api.domain.dto.AppLayoutDto;
import cn.com.duiba.developer.center.api.domain.paramquery.PageQueryEntity;
import cn.com.duiba.developer.center.api.domain.vo.PaginationVO;
import cn.com.duiba.wolf.dubbo.DubboResult;
import com.google.common.collect.Multimap;

/**
 * Created by liuyao on 16/7/27.
 */
public interface RemoteAppLayoutService {
    /**
     * 获取系统分页皮肤列表
     * @param params
     * @return
     */
    DubboResult<PaginationVO<AppLayoutBrickDto>> getSystemLayoutPage(PageQueryEntity params);

    /**
     * 获取定制分页皮肤列表
     * @param params
     * @return
     */
    DubboResult<PaginationVO<AppLayoutBrickDto>> getCustomLayoutPage(PageQueryEntity params);

    /**
     * 开发者更新主题色
     * @param appId
     * @param color
     * @return
     */
    DubboResult<Boolean> updateThemeColor(Long appId,String color);

    /**
     * 开发选择使用楼层皮肤
     * @param appId
     * @param skinId
     * @return
     */
    DubboResult<Boolean> devSetSkin(Long appId, Long skinId);

    /**
     * 开发选择使用楼层皮肤
     * @param appId
     * @param skinId
     * @param ignoreFloorIds 需要忽略的楼层Id,忽略的楼层将会出现在楼层待选区
     * @return
     */
    DubboResult<Boolean> devSetSkin(Long appId, Long skinId,List<Long> ignoreFloorIds);

    /**
     * [{id:楼层Id,floorType:楼层类型,enable:是否展示}]
     * @param appId
     * @param floorSortList
     * @return
     */
    DubboResult<Boolean> devReSetFloorList(Long appId,JSONArray floorSortList);

    /**
     * 隐藏指定的楼层,将对应楼层的enable变成false
     * @param appId
     * @param floorIds
     * @return
     */
    DubboResult<Integer> closeFloors(Long appId, Set<Long> floorIds);
    /**
     * 根据appId和floorId更新楼层配置
     * 如果楼层配置不存在，则把配置信息写入到developDataShowJson中；如果楼层配置存在，则更新developDataShowJson中的配置信息
     *
     * @author zhanglihui
     * @param appId       app主键
     * @param floorId     楼层ID
     * @param floorConfig 楼层配置，楼层配置，配置项key值参见相应枚举对象 （ActivityFloorConfKeyEnum，CouponFloorConfKeyEnum， SnapUpFloorConfKeyEnum ...）
     * @return 
     * @since JDK 1.6
     */
    DubboResult<Integer> updateDevFloorConfigByAppId(Long appId, Long floorId, Map<String, Object> floorConfig);

    /**
     * 高并发调用接口
     * @param appId
     * @return
     */
    DubboResult<AppLayoutDto> getAppLayout(Long appId);

    /**
     * 找出使用指定皮肤的AppLayoutDto
     * @param skinId
     * @return
     */
    DubboResult<List<AppLayoutDto>> findAppLayoutsUseSkin(Long skinId);

}
