package cn.com.duiba.developer.center.api.remoteservice;

import cn.com.duiba.developer.center.api.domain.dto.AppIconDto;
import cn.com.duiba.developer.center.api.domain.enums.AppIconStatusEnum;
import cn.com.duiba.developer.center.api.domain.paramquery.AppIconParams;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;

/**
 * Created by sty on 2017/5/9.
 */
public interface RemoteAppIconService {
    /**
     * 根据id查找对应的icon
     *
     * @param id
     * @return
     */
    DubboResult<AppIconDto> findById(long id);

    /**
     * 根据ID批量查询
     * @param ids
     * @return
     */
    DubboResult<List<AppIconDto>> findByIds(List<Long> ids);

    /**
     * 查询所有可用icon
     * @return
     */
    DubboResult<List<AppIconDto>> findAll();

    /**
     * 分页查询列表
     *
     * @param params
     * @return
     */
    DubboResult<List<AppIconDto>> pageSearch(AppIconParams params);

    /**
     * 分页查询总数
     *
     * @param params
     * @return
     */
    DubboResult<Integer> count4PageSearch(AppIconParams params);

    /**
     * 新增一个icon
     *
     * @param dto
     * @return icon的 id
     */
    DubboResult<Long> insert(AppIconDto dto);

    /**
     * 保存一个icon
     *
     * @param dto
     * @return
     */
    DubboResult<Boolean> upadteById(AppIconDto dto);

    /**
     * 定向开关切换
     *
     * @param id
     * @return
     */
    DubboResult<Boolean> directSwitch(long id, boolean isOpen);

    /**
     * 改变icon的状态
     *
     * @param id
     * @param enums
     * @return
     */
    DubboResult<Boolean> changeStatus(long id, AppIconStatusEnum enums);

    /**
     * 删除一个icon
     *
     * @param id
     * @return
     */
    DubboResult<Boolean> delete(long id);

    /**
     * 根据app和状态查找
     *
     * @param enums
     * @return
     */
    DubboResult<List<AppIconDto>> findByOpenStatus(AppIconStatusEnum enums);
}
