package cn.com.duiba.developer.center.api.remoteservice;

import cn.com.duiba.developer.center.api.domain.dto.CenterConfigDto;
import cn.com.duiba.developer.center.api.domain.enums.CenterConfigEnum;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;

/**
 * Created by liuyao on 2016/9/28.
 */
public interface RemoteCenterConfigService {
    /**
     * 获取配置
     * @param type
     * @return
     */
    DubboResult<CenterConfigDto> findCenterConfig(CenterConfigEnum type);

    /**
     * 根据id查找
     * @param id
     * @return
     */
    DubboResult<CenterConfigDto> find(Long id);

    /**
     * 新插入
     * @param centerConfigDto
     */
    DubboResult<Long> insert(CenterConfigDto centerConfigDto);

    /**
     * 更新配置
     * @param centerConfigDto
     * @return
     */
    DubboResult<Integer> update(CenterConfigDto centerConfigDto);


    DubboResult<List<CenterConfigDto>> findByPrice(String start, String end);

    DubboResult<CenterConfigDto> findByType(CenterConfigEnum type);
}
