package cn.com.duiba.developer.center.api.domain.dto;

import java.util.Date;
import java.util.List;
import java.util.Map;

import cn.com.duiba.developer.center.api.domain.enums.DuibaTaskStatusEnum;
import cn.com.duiba.developer.center.api.domain.enums.PushSourceTypeEnum;
import cn.com.duiba.developer.center.api.domain.enums.PushTypeEnum;

/**
 * @Author【yaocheng@duiba.com.cn】
 * @Date 2016/11/8 21:09
 */
public class DuibaTaskDto extends BaseDto{
    /**
     */
    private static final long   serialVersionUID = -7793988822345648079L;

    /** APP计划任务主键 */
    private Long                id;

    /**计划任务标题*/
    private String               title;

    /** 推送内容类型 {@link PushSourceTypeEnum} */
    private String              sourceType;

    /**推送内容名称*/
    private String               sourceName;


    /** 推送入口类型 {@link PushTypeEnum} */
    private List<String> pushTypes;

    /** APP计划任务执行状态 {@link DuibaTaskStatusEnum} */
    private String              status;

    /** 推送时间 */
    private Date                pushTime;

    /** 扩展字段 */
    private Map<String, String> extParam;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getSourceType() {
        return sourceType;
    }

    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }

    public String getSourceName() {
        return sourceName;
    }

    public void setSourceName(String sourceName) {
        this.sourceName = sourceName;
    }

    public List<String> getPushTypes() {
        return pushTypes;
    }

    public void setPushTypes(List<String> pushTypes) {
        this.pushTypes = pushTypes;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public Date getPushTime() {
        return pushTime;
    }

    public void setPushTime(Date pushTime) {
        this.pushTime = pushTime;
    }

    public Map<String, String> getExtParam() {
        return extParam;
    }

    public void setExtParam(Map<String, String> extParam) {
        this.extParam = extParam;
    }
}
