package cn.com.duiba.developer.center.api.domain.enums;

import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Created by xutao on 2017/7/3.
 */
public enum UploadImageEnum {
    BANNER_IMAGE_NEW("bannerImgNew","新版首页banner"),
    SMALL_IMAGE_NEW("smallImgNew","新版缩略图");

    private static final Logger log = LoggerFactory.getLogger(UploadImageEnum.class);

    private String code;
    private String desc;

    UploadImageEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public static UploadImageEnum getUploadImageEnumByCode(String code) {
        UploadImageEnum[] tempEnums = UploadImageEnum.values();
        for (UploadImageEnum tempEnum : tempEnums) {
            if (StringUtils.equals(code, tempEnum.getCode())) {
                return tempEnum;
            }
        }
        log.warn("[UploadImageEnum-getUploadImageEnumByCode]cant match any Enum,return null, code={}",code);
        return null;
    }
}
