/**
 * duiba-developer AmbDeveloperWithdrawCashOrderDAO.java
 * 
 * File Created at 2015年12月24日 下午8:03:11
 * $Id$
 *
 * Copyright 2015 duiba.com Croporation Limited.
 * All rights reserved.
 */
package cn.com.duiba.developer.center.api.remoteservice;

import java.util.List;
import java.util.Map;

import cn.com.duiba.developer.center.api.domain.dto.AmbDeveloperWithdrawCashOrderDto;
import cn.com.duiba.wolf.dubbo.DubboResult;


/**
 *
 * @create 2015年12月24日 下午8:03:11
 * @author Hermit
 * @version
 */
public interface RemoteAmbDeveloperWithdrawCashOrderService {
    /**
     * 创建开发者撤回订单
     * @param ambDeveloperWithdrawCashOrderDto
     * @return
     */
    public DubboResult<AmbDeveloperWithdrawCashOrderDto> insert(AmbDeveloperWithdrawCashOrderDto ambDeveloperWithdrawCashOrderDto);


    /**
     * 获取订单分页列表
     * @param queryPamas(developerId,offset,max)
     * @return
     */
    public DubboResult<List<AmbDeveloperWithdrawCashOrderDto>> findCashOrderList(Map<String, Object> queryPamas);

    /**
     * 获取订单分页总数
     * @param queryPamas
     * @return
     */
    public DubboResult<Long> findCashOrderCount(Map<String, Object> queryPamas);

    /**
     * 将订单置为待支付状态
     * @param cashOrderId
     * @return
     */
    public DubboResult<Integer> updateStatusCreateToWaitPay(Long cashOrderId);

    /**
     * 将订单置为待失败状态
     * @param cashOrderId
     * @return
     */
    public DubboResult<Integer> updateStatusCreateToFail(Long cashOrderId);
    /**
     * 将订单置为待成功状态
     * @param cashOrderId
     * @return
     */
    public DubboResult<Integer> updateStatusCreateToSuccess(Long cashOrderId);
    
}
