package cn.com.duiba.developer.center.api;

/**
 * 开发者中心异常类，若异常有明确定义请指明exCode {@link cn.com.duiba.developer.center.api.DCExceptionCode}
 * Created by liuyao on 2017/2/13.
 */
public class DeveloperCenterException extends RuntimeException{
    /**
     * 异常编码， 默认取未知异常
     */
    private String exCode = DCExceptionCode.Unknow;

    public DeveloperCenterException(String message, Throwable cause) {
        super(message, cause);
    }
    public DeveloperCenterException(String message, Throwable cause, String exCode) {
        super(message, cause);
    }

    public DeveloperCenterException(Throwable cause) {
        super(cause);
    }

    public DeveloperCenterException(Throwable cause, String exCode) {
        super(cause);
    }

    public DeveloperCenterException(String message) {
        super(message);
    }

    public DeveloperCenterException(String message, String exCode) {
        super(message);
    }

    public String getExCode() {
        return exCode;
    }

    public void setExCode(String exCode) {
        this.exCode = exCode;
    }
}
