package cn.com.duiba.developer.center.api.aspectj;

import cn.com.duiba.developer.center.api.utils.CacheConstants;
import cn.com.duiba.wolf.cache.AdvancedCacheClient;
import cn.com.duiba.wolf.dubbo.DubboResult;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;

/**
 * Created by xiaoxuda on 2017/2/27.
 */
@Aspect
public class Aspect4RemoteAppService {
    private AdvancedCacheClient advancedCacheClient;

    private static String getKeyByAppId(Long appId) {
        return CacheConstants.KEY_APP + appId;
    }

    private static String getKeyByAppKey(String appKey) {
        return CacheConstants.KEY_APP + appKey;
    }

    /**
     * 拦截对dubbo接口RemoteAppService的getSimpleApp方法的调用，利用缓存降低调用量
     *
     * @param proceedingJoinPoint
     * @return
     */
    @Around("execution(* cn.com.duiba.developer.center.api.remoteservice.RemoteAppService.getSimpleApp(..))")
    public Object aroundGetSimpleApp(ProceedingJoinPoint proceedingJoinPoint) throws Throwable {
        Object result = null;
        //首先查询缓存，查询不到结果在调用dubbo接口
        Long appId = (Long) proceedingJoinPoint.getArgs()[0];
        if (advancedCacheClient != null) {
            result = advancedCacheClient.get(getKeyByAppId(appId));
        }
        if (result != null) {
            result = DubboResult.successResult(result);
        } else {
            result = proceedingJoinPoint.proceed();
        }
        return result;
    }

    /**
     * 拦截对dubbo接口RemoteAppService的getSimpleApp方法的调用，利用缓存降低调用量
     *
     * @param proceedingJoinPoint
     * @return
     */
    @Around("execution(* cn.com.duiba.developer.center.api.remoteservice.RemoteAppService.getAppByAppKey(..))")
    public Object aroundGetAppByAppKey(ProceedingJoinPoint proceedingJoinPoint) throws Throwable {
        Object result = null;
        //首先查询缓存，查询不到结果在调用dubbo接口
        String appKey = (String) proceedingJoinPoint.getArgs()[0];
        if (advancedCacheClient != null) {
            result = advancedCacheClient.get(getKeyByAppKey(appKey));
        }
        if (result != null) {
            result = DubboResult.successResult(result);
        } else {
            result = proceedingJoinPoint.proceed();
        }
        return result;
    }

    public void setAdvancedCacheClient(AdvancedCacheClient advancedCacheClient) {
        this.advancedCacheClient = advancedCacheClient;
    }
}
