package cn.com.duiba.developer.center.api.domain.dto;

import cn.com.duiba.developer.center.api.domain.enums.AppIconStatusEnum;

import java.io.Serializable;
import java.util.Date;

/**
 * Created by sty on 2017/5/9.
 */
public class AppIconDto implements Serializable {

    private static final long serialVersionUID = -5618832028264265052L;

    public static final Integer AppDirectSwitch = 1;

    public static final Integer AppOpenBubbleSwitch = 2;

    /**
     * id
     */
    private Long id;

    /**
     * 标题
     */
    private String title;

    /**
     * 指向内容
     */
    private String target;

    /**
     * 描述
     */
    private String description;

    /**
     * 图标
     */
    private String image;

    /**
     * 气泡图标
     */
    private String bubbleImage;

    /**
     * 功能开关集合，通过位运算获取具体开关状态
     **/
    private Integer switches;

    /**
     * 图标状态
     */
    private AppIconStatusEnum openStatus;

    /**
     * 创建时间
     */
    private Date gmtCreated;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 删除状态，用户软删除
     */
    private Boolean deleted;

    /**
     * 判断开关是否打开
     * @param switchInt
     * @return
     */
    public boolean isSwitchOpen(int switchInt){
        int v = 1 << switchInt;
        int ret = switches & v;
        return ret != 0;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTarget() {
        return target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getImage() {
        return image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public String getBubbleImage() {
        return bubbleImage;
    }

    public void setBubbleImage(String bubbleImage) {
        this.bubbleImage = bubbleImage;
    }

    public Integer getSwitches() {
        return switches;
    }

    public void setSwitches(Integer switches) {
        this.switches = switches;
    }

    public AppIconStatusEnum getOpenStatus() {
        return openStatus;
    }

    public void setOpenStatus(AppIconStatusEnum openStatus) {
        this.openStatus = openStatus;
    }

    public Date getGmtCreated() {
        return gmtCreated;
    }

    public void setGmtCreated(Date gmtCreated) {
        this.gmtCreated = gmtCreated;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public Boolean getDeleted() {
        return deleted;
    }

    public void setDeleted(Boolean deleted) {
        this.deleted = deleted;
    }
}
