/**
 * Project Name:developer-center-api
 * File Name:RemoteAppPushTaskService.java
 * Package Name:cn.com.duiba.developer.center.api.remoteservice
 * Date:2016年11月2日下午10:01:35
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.developer.center.api.remoteservice.schedule;

import java.util.Date;
import java.util.List;
import java.util.Map;

import cn.com.duiba.developer.center.api.domain.dto.AppPushTaskDto;
import cn.com.duiba.developer.center.api.domain.dto.DuibaTaskDto;
import cn.com.duiba.developer.center.api.domain.dto.OperateLogDto;
import cn.com.duiba.developer.center.api.domain.enums.AppPushStatusEnum;
import cn.com.duiba.developer.center.api.domain.vo.PaginationVO;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * app计划任务推送服务dubbo接口 <br/>
 * Date:     2016年11月2日 下午10:01:35 <br/>
 * @author   zhanglihui
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
public interface RemoteAppPushTaskService {

    /**
     * 查询待执行的app推送任务<br/>
     * 查询条件：push_time <= now() and status = 'TO_EXEC'
     * @author zhanglihui
     * @return
     * @since JDK 1.6
     */
    DubboResult<List<AppPushTaskDto>> queryAppPushTaskToExec();

    /**
     *  根据duibaTaskId查询兑吧计划任务
     * @param duibaTaskId
     * @return
     */
    DubboResult<AppPushTaskDto> findDuibaTaskById(Long duibaTaskId);

    /**
     *  根据appTaskId查询开发者计划任务
     * @param id
     * @return
     */
    DubboResult<AppPushTaskDto> findAppTaskById(Long id);
    
    /**
     * 
     * 更新计划任务状态
     *
     * @author zhanglihui
     * @param appPushTaskId 任务主键
     * @param status        要更新的状态 {@link AppPushStatusEnum}
     * @return
     * @since JDK 1.6
     */
    DubboResult<Void> updateAppPushTaskStatus(long appPushTaskId, String status);
    
    /**
     * 更新计划任务执行时间
     *
     * @author zhanglihui
     * @param appPushTaskId 任务主键
     * @param pushTime      执行时间
     * @return
     * @since JDK 1.6
     */
    DubboResult<Void> updateAppPushTaskTime(long appPushTaskId, Date pushTime);

    /**
     * 更新计划任务扩展信息<br/>
     *
     * @author zhanglihui
     * @param appPushTaskId  任务主键
     * @param key            需要放入extParam中的键
     * @param value          需要放入extParam中的值
     * @return
     */
    DubboResult<Void> updateExtParamById(long appPushTaskId, String key, String value);
    /**
     * 根据duibaTaskId查询需要推送的app任务列表</br>
     * 查询条件： status = 'INIT'
     *
     * @author yaocheng
     * @param  duibaTaskId
     * @return List<AppPushTaskDto>
     * @since JDK 1.6
     */
    DubboResult<List<AppPushTaskDto>> queryAppPushTaskForEdit(Long duibaTaskId);

    /**
     * 创建或编辑计划任务
     * @param appPushTasks
     * @return Boolean
     */
    DubboResult<Long> create(List<AppPushTaskDto> appPushTasks);

    /**
     * 立即执行计划任务
     * @param duibaTaskId
     * @return
     */
    DubboResult<Boolean> executeRightNow(Long duibaTaskId);

    /**
     * 删除计划任务
     * @param duibaTaskId
     * @return
     */
    DubboResult<Boolean> delete(Long duibaTaskId);
    /**
     *	计划任务列表查询
     * @param pageIndex
     * @param pageSize
     * @param appPushTaskDto
     * @return
     */
    DubboResult<PaginationVO<DuibaTaskDto>> findScheduledTaskList(int pageIndex, int pageSize, DuibaTaskDto appPushTaskDto);
    /**
     * 计划任务下app列表查询
     * @param pageIndex
     * @param pageSize
     * @param duibaTaskId
     * @return
     */
    DubboResult<PaginationVO<AppPushTaskDto>> findScheduledTaskAppList(int pageIndex,int pageSize,Long duibaTaskId);
    /**
     * 批量查询计划任务下app数量
     * @param duibaTaskIds
     * @return
     */
    DubboResult<Map<Long,Integer>> findBatchScheduledTaskAppNums(List<Long> duibaTaskIds);
    
    /**
     * 开启计划任务，并且将tb_credits_app_push_task状态置为待执行（TO_EXEC）
     * @param duibaTaskId 兑吧计划任务ID
     * @return
     */
    DubboResult<Void> openPushTask(Long duibaTaskId);
 
    /**
     * 关闭计划任务，并且将tb_credits_app_push_task状态置为初始化（INIT）
     * @param duibaTaskId 兑吧计划任务ID
     * @return
     */
    DubboResult<Void> closePushTask(Long duibaTaskId);

    /**
     * 记录管理员操作日志
     * @param operateLogDto
     * @return
     */
    DubboResult<Void>  insertOperateLog(OperateLogDto operateLogDto);
    
    /**
     * 根据appId查询待执行开发者计划任务列表
     *
     * @author zhanglihui
     * @param appId 应用ID
     * @return 待执行开发者计划任务列表
     */
    DubboResult<List<AppPushTaskDto>> queryAppPushTasksByAppId(Long appId);
    
    /**
     * 开发者创建计划任务
     *
     * @author zhanglihui
     * @param appPushTaskDto
     * @return void
     */
    DubboResult<Void> createForDev(AppPushTaskDto appPushTaskDto);
    
    /**
     * 根据计划任务主键删除计划任务
     *
     * @author zhanglihui
     * @param appPushTaskId
     * @param appId
     * @return void
     */
    DubboResult<Void> deleteForDev(long appPushTaskId, long appId);
    
    /**
     * 根据appId查询待执行计划任务数量
     *
     * @author zhanglihui
     * @param appId
     * @return 待执行计划任务数
     */
    DubboResult<Integer> queryTaskCount(long appId);
}

