package cn.com.duiba.developer.center.api.utils;

import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Set;

/**
 * Created by liuyao on 16/7/18.
 */
public class CacheConstants {

    public static final String KEY_APP                              = "dcm_key_appId_";
    public static final String KEY_DEVELOPER                        = "dcm_keyDeveloperId_";
    public static final String KEY_APP_EXTRA_SIMPLE_BY_APP_ID       = "dcm_keyAppExtraSimpleByAppId1_";
    public static final String KEY_APP_EXTRA_PROGRAM_BY_APP_ID      = "dcm_keyAppExtraProgramByAppId1_";
    public static final String KEY_APP_EXTRA_SAHRE_PROGRAM_BY_APP_ID= "dcm_keyAppExtraShareProgramByAppId_";
    public static final String KEY_APP_EXTRA_DUIBA_SAHRE_BY_APP_ID  = "dcm_keyAppExtraDuibaShareByAppId_";
    public static final String KEY_APP_LAYOUT_BY_APPID              = "dcm_keyAppLayoutByAppId_";
    public static final String KEY_APP_LAYOUT_BRICK_SIMPLE_BY_ID    = "dcm_keyAppLayoutSimpleById_";
    public static final String KEY_APP_VIP_LIMIT_BY_APPID           = "dcm_keyAppVipLimitByAppId_";
    public static final String FIRST_APP_OF_DEV_ID                  = "dcm_firstAppOfDevId_";
    public static final String KEY_APP_BUDGET_BY_APP_ID             = "dcm_keyAppBudgetByAppId_";
    public static final String KEY_APP_BANNER_ID                  = "dcm_key_bannerId_";
    public static final String KEP_HOME_APP_BANNERS               = "dcm_key_home_appBanners";
    public static final String KEY_NEW_SKIN_APP_ID                  = "dcm_keyNewSkinAppId_";
    public static final String KEY_SUB_SKIN_ID                  = "dcm_keySubSkinId_";
    public static final String KEY_APP_AEROSOL_BY_APP_ID          = "dcm_keyAppAerosolByAppId_";
    public static final String KEY_APP_ICON_BY_ID                = "dcm_keyAppIconById_";

    public static final String KEY_APP_EXTRA_NAV_PROGRAM_BY_APPID    = "dcm_keyAppExtraNavProgramAppId_";
    /**
     * 地址限制列表的缓存key
     */
    public static final String KEY_ADDR_LIMIT_BY_ITEM_ID          = "chaos_keyAddrLimitByItemId_";
    public static final String KEY_ADDR_LIMIT_BY_APP_ITEM_ID      = "chaos_keyAddrLimitByAppItemId_";

    /**
     * 为了获取所有的有效的AppIds,又防止平级调用,将所有有效App存入缓存中,达到共享,Set<Long>
     */
    public static final String DEVELOPER_CENTER_ENABLE_APPIDS = "developer.center.enable.appIds";
    /**
     * 首页APP商品缓存
     */
    public static final String MS_HOME_ITEM                       = "item.MS_HOME_ITEM_";

    public static final String MAIN_MEET_BY_ID                    = "dcm_mainmeetById_";
    //center config
    public final static String CENTER_CONFIG_CACHE_KEY = "dcm_key_center_config_";
    public final static String CACHE_CENTER_CONFIG_ID = "dcm_key_center_config_id_";


    // 不允许存在相同的静态常量,这里做判断,如果有相同的就抛出异常
    static {
        Field[] fields = CacheConstants.class.getFields();
        Set<String> set = new HashSet<>();
        for (Field f : fields) {
            try {
                boolean success = set.add(f.get(null) + "_" + f.getType().getName());
                if (!success) {
                    throw new IllegalAccessException("duplicated value: [" + f.get(null) + "] ,please modify one of them");
                }
            } catch (IllegalAccessException e) {
                throw new ExceptionInInitializerError(e);
            }
        }
    }
}
