package cn.com.duiba.developer.center.api.domain.dto;

import com.google.common.collect.ImmutableSet;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.LinkedList;

/** 
 * @author sunyan
 * @version 创建时间：2017年4月12日 下午2:50:53
 */
public class AppNewExtraDto implements Serializable {
    private static final long serialVersionUID = -8083052631355120698L;

    public static final String SEC_KILL_VALIDATION_SLIDE = "1"; //秒杀滑动类型验证码
    public static final String SEC_KILL_VALIDATION_CLICK = "2"; //秒杀点击类型验证码
    public static final String EXCHANGE_VALIDATION_SLIDE = "1"; //普兑滑动类型验证码
    public static final String EXCHANGE_VALIDATION_CLICK = "2"; //普兑点击类型验证码

    public static final String  APP_ID = "appId";
    public static final String _BD = "bd";//bd联系人
    public static final String DAILY_ACT_LOGIN_UV = "dailyActLoginUv";//上月日均活动登录UV
    public static final String ONLINE_DATE = "onlineDate";//上线日期
    public static final String FLOW_RULE = "flowRule";
    public static final String COUPON_STOCK_WARN = "couponStockWarn";//自有优惠券/虚拟商品库存预警线
    public static final String OBJECT_STOCK_WARN = "objectStockWarn";//自有实物库存预警线
    public static final String NOT_LOGIN_PLAY_GAME = "notLoginPlayGame";//未登录是否可以参与游戏
    public static final String SEC_KILL_VALIDATION_KEY = "secKillValidation"; //秒杀验证码类型
    public static final String EXCHANGE_VALIDATION_KEY = "exchangeValidation"; //普兑验证码类型
    public static final String CONSUME_VIRTUAL_CARD = "consumeVirtualCard";//扣虚拟卡链接key
    public static final String CONSUME_VIRTUAL_CARD_NOTIFY = "consumeVirtualCardNotify";//扣虚拟卡链接key
    public static final String FLOW_VIEW_TIME="flowViewTime";//流量策略展示时间key
    /**
     * 谢谢参与转福袋例外的活动id列表
     */
    public static final String THANKS_TO_LUCKY_EXCLUDE_ACTIDS = "thxLuckyExcludeActIds";


    public static final ImmutableSet<String> propSet;
    static {
        Field[] fields = AppNewExtraDto.class.getDeclaredFields();
        LinkedList pros = new LinkedList();
        for(int i=0; i< fields.length; i++){
            if(Modifier.isStatic(fields[i].getModifiers())){
                continue;
            }
            pros.add(fields[i].getName());
        }
        propSet = ImmutableSet.copyOf(pros);
    }

    private Long appId;
    private String bd;//bd联系人
    private String dailyActLoginUv;//上月日均活动登录UV
    private String onlineDate;//上线日期
    private Boolean flowRule;  
    private Integer couponStockWarn;//自有优惠券/虚拟商品库存预警线  
    private Integer objectStockWarn;//自有实物库存预警线
    private Boolean notLoginPlayGame;//未登录是否可以参与游戏
    private String secKillValidation; //秒杀验证码类型
    private String exchangeValidation; //普兑验证码类型
    private String consumeVirtualCard;//扣虚拟卡链接
    private String consumeVirtualCardNotify;//扣虚拟卡通知
    private String flowViewTime;//流量策略券展示时间
    /**
     * 谢谢参与转福袋例外的活动id列表
     */
    private String thxLuckyExcludeActIds;

    public String getSecKillValidation() {
        return secKillValidation;
    }

    public void setSecKillValidation(String secKillValidation) {
        this.secKillValidation = secKillValidation;
    }

    public String getExchangeValidation() {
        return exchangeValidation;
    }

    public void setExchangeValidation(String exchangeValidation) {
        this.exchangeValidation = exchangeValidation;
    }

    public Long getAppId() {
        return appId;
    }
    public void setAppId(Long appId) {
        this.appId = appId;
    }
    public String getBd() {
        return bd;
    }
    public void setBd(String bd) {
        this.bd = bd;
    }
    public String getDailyActLoginUv() {
        return dailyActLoginUv;
    }
    public void setDailyActLoginUv(String dailyActLoginUv) {
        this.dailyActLoginUv = dailyActLoginUv;
    }
    public String getOnlineDate() {
        return onlineDate;
    }
    public void setOnlineDate(String onlineDate) {
        this.onlineDate = onlineDate;
    }

    public Boolean getFlowRule() {
        return flowRule;
    }

    public void setFlowRule(Boolean flowRule) {
        this.flowRule = flowRule;
    }
    public Integer getCouponStockWarn() {
        return couponStockWarn;
    }
    public void setCouponStockWarn(Integer couponStockWarn) {
        this.couponStockWarn = couponStockWarn;
    }
    public Integer getObjectStockWarn() {
        return objectStockWarn;
    }
    public void setObjectStockWarn(Integer objectStockWarn) {
        this.objectStockWarn = objectStockWarn;
    }

    public Boolean getNotLoginPlayGame() {
        return notLoginPlayGame;
    }

    public void setNotLoginPlayGame(Boolean notLoginPlayGame) {
        this.notLoginPlayGame = notLoginPlayGame;
    }

    public String getConsumeVirtualCard() {
        return consumeVirtualCard;
    }

    public void setConsumeVirtualCard(String consumeVirtualCard) {
        this.consumeVirtualCard = consumeVirtualCard;
    }

    public String getConsumeVirtualCardNotify() {
        return consumeVirtualCardNotify;
    }

    public void setConsumeVirtualCardNotify(String consumeVirtualCardNotify) {
        this.consumeVirtualCardNotify = consumeVirtualCardNotify;
    }

    public String getFlowViewTime() {
        return flowViewTime;
    }

    public void setFlowViewTime(String flowViewTime) {
        this.flowViewTime = flowViewTime;
    }

    public String getThxLuckyExcludeActIds() {
        return thxLuckyExcludeActIds;
    }

    public void setThxLuckyExcludeActIds(String thxLuckyExcludeActIds) {
        this.thxLuckyExcludeActIds = thxLuckyExcludeActIds;
    }
}
