package cn.com.duiba.developer.center.api.remoteservice;

import cn.com.duiba.developer.center.api.domain.dto.AppNewExtraDto;
import cn.com.duiba.developer.center.api.domain.dto.appextra.CustomServicePageConfigDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;


/**
 * @author sunyan
 * @version 创建时间：2017年4月12日 下午3:01:46
 */
public interface RemoteAppNewExtraService {
    /**
     * 批量获取AppNewExtra
     *
     * @param appIds
     * @return
     */
    DubboResult<List<AppNewExtraDto>> findByAppIds(List<Long> appIds);

    /**
     * 修改bd联系人
     *
     * @param appId
     * @param value
     * @return
     */
    DubboResult<Boolean> updateBd(Long appId, String value);

    /**
     * 修改上月日均活动登录UV
     *
     * @param appId
     * @param value
     * @return
     */
    DubboResult<Boolean> updateDailyActLoginUv(Long appId, String value);

    /**
     * 修改上线时间
     *
     * @param appId
     * @param value
     * @return
     */
    DubboResult<Boolean> updateOnlineDate(Long appId, String value);

    /**
     * 按指定扩展字段和值批量获取AppNewExtra(只含有appId和传入的扩展字段值)
     *
     * @param key
     * @param value
     * @return
     */
    DubboResult<List<AppNewExtraDto>> findByKeyValue(String key, String value);

    /**
     * @param appId
     * @param value
     * @return
     */
    DubboResult<Boolean> updateFlowRule(Long appId, Boolean value);

    /**
     * 查询app扩展信息
     * @param appId
     * @return
     */
    DubboResult<AppNewExtraDto> findByAppId(Long appId);

    /**
     * @param appId
     * @param value
     * @return
     */
    DubboResult<Boolean> updateCouponStockWarn(Long appId, Long value);

    /**
     * @param appId
     * @param value
     * @return
     */
    DubboResult<Boolean> updateObjectStockWarn(Long appId, Long value);

    /**
     * @param appId
     * @param value
     * @return
     */
    DubboResult<Boolean> updateNotLoginPlayGame(Long appId, String value);

    /**
     * 更新扣虚拟卡请求链接
     * @param appId
     * @param consumeUrl
     * @return
     */
    DubboResult<Boolean> updateConsumeVirtualCard(Long appId, String consumeUrl);

    /**
     * 更新扣虚拟卡请求链接
     * @param appId
     * @param consumeNotifyUrl
     * @return
     */
    DubboResult<Boolean> updateConsumeVirtualCardNotify(Long appId, String consumeNotifyUrl);

    /**
     * 更新流量策略券时间
     * @param appId
     * @param consumeNotifyUrl
     * @return
     */
    DubboResult<Boolean> updateFlowViewTime(Long appId, String consumeNotifyUrl);

    /**
     * 更新例外活动id列表
     * @param appId
     * @param value
     * @return
     */
    Boolean updateThxLuckyExcludeActIds(Long appId, String value);

    /**
     * 更新流量策略-人工干预商品区
     * @param appId
     * @param value
     * @return
     */
    Boolean updateGoodArea(Long appId, Boolean value);

    /**
     * 更新流量策略-人工干预活动免费次数
     * @param appId
     * @param value
     * @return
     */
    Boolean updateFreeLimit(Long appId, Boolean value);

    /**
     * 更新客服页面 配置
     * @param customServicePageConfigDto
     * @return
     */
    Boolean updateCustomServicePageConfig(Long appId,CustomServicePageConfigDto customServicePageConfigDto);
 }
