package cn.com.duiba.developer.center.api.remoteservice.floor;

import java.util.Collection;
import java.util.List;
import java.util.Set;

import cn.com.duiba.developer.center.api.domain.enums.FloorDataTypeEnum;
import com.alibaba.fastjson.JSONObject;

import cn.com.duiba.developer.center.api.domain.dto.CreditsFloorCodeCopyDto;
import cn.com.duiba.developer.center.api.domain.dto.CreditsFloorCodeDto;
import cn.com.duiba.developer.center.api.domain.paramquery.FloorPageParams;
import cn.com.duiba.developer.center.api.domain.vo.PaginationVO;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * Created by suyuanlong on 16/8/10.
 */
public interface RemoteCreditsFloorCodeService {
    /**
     * 创建楼层
     * @param dto
     * @return
     */
    DubboResult<CreditsFloorCodeDto> insertFloorCode(CreditsFloorCodeDto dto);

    /**
     * 更新楼层
     * @param dto
     * @return
     */
    DubboResult<Integer> updateFloorCode(CreditsFloorCodeDto dto);

    /**
     * 按类型加载楼层
     * @param params
     * @return
     */
    DubboResult<PaginationVO<JSONObject>> selectFloorCodesByType(FloorPageParams params);

    /**
     * 按数据类型加载楼层
     * @param dataTypeEnum
     * @return
     */
    DubboResult<List<CreditsFloorCodeDto>> findFloorByDataType(FloorDataTypeEnum dataTypeEnum);

    /**
     * 通用查询，禁止用于高并发调用
     * @return
     */
    DubboResult<List<CreditsFloorCodeDto>> findFloor2Common(CreditsFloorCodeDto param);

    /**
     * 加载单个楼层详情
     * @param id
     * @return
     */
    DubboResult<CreditsFloorCodeDto> selectFloorCodeById(Long id);

    /**
     * 查询皮肤下所有的楼层副本
     * @param skinId
     * @return
     */
    DubboResult<List<CreditsFloorCodeCopyDto>> seletCodeCopyListBySkinId(Long skinId);

    /**
     * 批量加载皮肤楼层
     * @param ids
     * @return
     */
    DubboResult<List<CreditsFloorCodeDto>> getFloorCodeList(Collection<Long> ids);

    /**
     * 删除楼层
     * @param floorId
     * @return
     */
    DubboResult<Boolean> deleteFloor(Long floorId);

    /**
     * 获取正在使用指定楼层的app信息
     * @param params
     * @return
     */
    DubboResult<PaginationVO<JSONObject>> findAppByFloorId(FloorPageParams params);

    /**
     * 根据设置的过期时间获取相对于当前时间已经过期的所有楼层副本
     */
    DubboResult<List<CreditsFloorCodeCopyDto>> findOverdueList();

    /**
     * 根据皮肤id获取所有相关的楼层副本
     */
    DubboResult<List<CreditsFloorCodeCopyDto>> findAllBySkinIds(Set<Long> skinIds);
}
