package cn.com.duiba.developer.center.api.remoteservice.floor;

import cn.com.duiba.developer.center.api.domain.dto.AppSimpleDto;
import cn.com.duiba.developer.center.api.domain.dto.CreditsFloorSkinDto;
import cn.com.duiba.developer.center.api.domain.dto.floor.FloorSkinDto;
import cn.com.duiba.developer.center.api.domain.paramquery.FloorPageParams;
import cn.com.duiba.developer.center.api.domain.vo.PaginationVO;
import cn.com.duiba.wolf.dubbo.DubboResult;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;

import java.util.List;

/**
 * 楼层代码服务
 */
public interface RemoteCreditsFloorSkinService {
    /**
     * 高并发访问接口:获取首页皮肤配置
     * 取代AppLoayoutDto和selectFloorSkinById,降低AppLoayoutDto的职责
     * 忽略所有老首页的逻辑
     * @param appId
     * @return
     */
    DubboResult<FloorSkinDto> getHomeSkin(Long appId);

    /**
     * 高并发访问接口:获取子页面皮肤配置
     * @param skinId
     * @return
     */
    DubboResult<FloorSkinDto> getSubSkin(Long skinId);

    /**
     * 加载皮肤分页列表,请使用selectFloorSkins
     * @param params 分页请求参数
     * @return
     */
    @Deprecated
    DubboResult<PaginationVO<JSONObject>> getSkinPage(FloorPageParams params);
    /**
     * 新建一个楼层皮肤
     * @param dto
     * @return
     */
    DubboResult<CreditsFloorSkinDto> insertFloorSkin(CreditsFloorSkinDto dto);

    /**
     * 更新一个楼层皮肤
     * @param dto 传入的新皮肤
     * @return
     */
    DubboResult<Integer> updateFloorSkin(CreditsFloorSkinDto dto);

    /**
     * 管理员端获取楼层分页列表
     * @param params 分页请求参数
     * @return 分页列表
     */
    DubboResult<PaginationVO<JSONObject>> selectFloorSkins(FloorPageParams params);

    /**
     * 高并发访问接口:获取皮肤配置
     * @param id
     * @return
     */
    DubboResult<CreditsFloorSkinDto> selectFloorSkinById(Long id);

    /**
     * 获取楼层编辑页回显数据,皮肤楼层配置信息
     * @param id 皮肤id
     * @return 楼层配置
     */
    DubboResult<JSONObject> getOneSkinConfig(Long id);

    /**
     * 开启或关闭定向开关
     * 1.已经有App使用的皮肤无法开启定向
     * 2.已经存在定向的皮肤无法关闭定向开关
     * @param id
     * @param isOpen
     * @return 开关当前状态
     */
    DubboResult<Boolean> switchSkinSpecify(Long id,Boolean isOpen);

    /**
     * 获取皮肤下所有的定向App
     * @param skinId
     * @return
     */
    DubboResult<List<AppSimpleDto>> getSpecifyAppList(Long skinId);

    /**
     * 添加app定向
     * @param skinId
     * @param appId
     * @return
     */
    DubboResult<Boolean> addAppSpecify(Long skinId,Long appId);

    /**
     * 删除皮肤与App的定向关系
     * @param skinId
     * @param appId
     * @return
     */
    DubboResult<Boolean> delAppSpecify(Long skinId,Long appId);

    /**
     * 切换显示状态
     * @param skinId
     * @param isOpen
     * @return
     */
    DubboResult<Integer> switchOpenState(Long skinId, Boolean isOpen);

    /**
     * 加载app可用的皮肤列表
     * 勾选的皮肤对象中会多一个 selected:true
     * @param appId
     * @return [{id:id,name:皮肤名称,floorType:皮肤类型,image:展示图},...]
     */
    DubboResult<List<JSONObject>> loadDevSkinList(Long appId);

    /**
     * 获取使用某楼层的皮肤
     * @param floorId
     * @return
     */
    DubboResult<List<CreditsFloorSkinDto>> findAllSkinUseFloor(Long floorId);

    /**
     * 获取用于一键换肤的App展示项
     * @param appIds
     * @return
     */
    DubboResult<JSONArray> findChangeSkinApps(Long skinId,List<Long> appIds);

    /**
     * 删除子页面皮肤
     * @param skinId
     * @return
     */
    DubboResult<Boolean> deleteSkin(Long skinId);

    /**
     * 通过appIds获取给定app正在使用的皮肤,返回皮肤信息以及正在使用这些皮肤的app的信息
     * [{id:皮肤Id,name:"皮肤名称",appList:[{id:应用Id,name:"应用名称"}]},..]
     * @param appIds
     * @return
     */
    DubboResult<JSONArray> findSkinsForAppUse(List<Long> appIds);

    /**
     * 根据皮肤id批量查询皮肤
     * @param skinIds
     * @return
     */
    DubboResult<List<CreditsFloorSkinDto>> findSkinsByIds(List<Long> skinIds);

    /**
     * 批量更新楼层皮肤
     * 用于定时任务自动下架楼层
     * 返回未更新成功的皮肤id
     * @param creditsFloorSkins 传入的新皮肤
     * @return
     */
    DubboResult<List<Long>> updateFloorSkinBatch(List<CreditsFloorSkinDto> creditsFloorSkins);

    /**
     * 根据appId查找当前适用皮肤, appId --> skinId
     * @param appId
     * @return
     */
    DubboResult<CreditsFloorSkinDto> findCurrentDevSkin(Long appId);
}
