/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.developer.center.api.domain.enums;

import cn.com.duiba.developer.center.api.domain.dto.floorconfig.ActivityJson;
import cn.com.duiba.developer.center.api.domain.dto.floorconfig.BannerJson;
import cn.com.duiba.developer.center.api.domain.dto.floorconfig.BaseJson;
import cn.com.duiba.developer.center.api.domain.dto.floorconfig.CouponJson;
import cn.com.duiba.developer.center.api.domain.dto.floorconfig.GameJson;
import cn.com.duiba.developer.center.api.domain.dto.floorconfig.GoodsJson;
import cn.com.duiba.developer.center.api.domain.dto.floorconfig.IconJson;
import cn.com.duiba.developer.center.api.domain.dto.floorconfig.SnapUpJson;
import com.google.common.collect.Maps;
import java.util.Map;

public enum FloorTypeEnum {
    Banner(1, "banner", BannerJson.class),
    ICON(2, "icon", IconJson.class),
    Goods(3, "\u5546\u54c1\u533a", GoodsJson.class),
    Rob(4, "\u4eca\u65e5\u5fc5\u62a2", SnapUpJson.class),
    Activity(5, "\u6d3b\u52a8\u697c\u5c42", ActivityJson.class),
    Coupon(6, "\u4f18\u60e0\u5238", CouponJson.class),
    Custom(7, "\u81ea\u5b9a\u4e49\u697c\u5c42", BaseJson.class),
    ShowCase(8, "\u6a71\u7a97\u533a", BaseJson.class),
    Game(9, "\u6e38\u620f\u4e2d\u5fc3", GameJson.class),
    Seckill(10, "\u514d\u5355\u79d2\u6740", BaseJson.class),
    Sign(11, "\u7b7e\u5230\u697c\u5c42", BaseJson.class),
    Task(12, "\u4efb\u52a1\u697c\u5c42", BaseJson.class),
    AppSeckill(13, "\u79d2\u6740\u5546\u54c1", BaseJson.class);

    private static Map<Integer, FloorTypeEnum> typeMap;
    private Integer type;
    private String name;
    private Class<? extends BaseJson> defaultConfigClass;

    public static FloorTypeEnum getByType(Integer type) {
        return typeMap.get(type);
    }

    public Integer getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public Class<? extends BaseJson> getDefaultConfigClass() {
        return this.defaultConfigClass;
    }

    private FloorTypeEnum(Integer type, String name, Class<? extends BaseJson> defaultConfigClass) {
        this.type = type;
        this.name = name;
        this.defaultConfigClass = defaultConfigClass;
    }

    static {
        typeMap = Maps.newHashMap();
        for (FloorTypeEnum typeClass : FloorTypeEnum.values()) {
            typeMap.put(typeClass.getType(), typeClass);
        }
    }
}

