package cn.com.duiba.developer.center.api.domain.dto;

import java.util.Date;

import cn.com.duiba.developer.center.api.domain.BaseDO;

/**
 * 手动变更申请单
 */
public class ManualChargeApplyDto extends BaseDO{
	private static final long serialVersionUID = -247230658677040611L;

	public static final String StatusCreate = "create"; //
	public static final String StatusSuccess = "success";// 
	public static final String StatusFail = "fail";// 
	public static final String StatusUnknow = "unknow"; //

	private Long id;
	private Long changeMoney;
	private String status;
	private String message;
	private Date finishTime;
	private Long developerId;
	private String memo;
	private Long adminId;
	private Date gmtCreate;
	private Date gmtModified;

	/**
	 * 无参构造函数
	 */
	public ManualChargeApplyDto(){
		this.toBeUpdate = false;
		this.toBeInsert = false;
	}

	/**
	 * 更新构造函数
	 * @param id 实体Id
	 */
	public ManualChargeApplyDto(Long id) {
		this.id = id;
		this.gmtModified = new Date();
		toBeUpdate = true;
	}

	/**
	 * 插入构造函数
	 * @param init4insert
     */
	public ManualChargeApplyDto(boolean init4insert) {
		if (init4insert) {
			toBeInsert = true;
			gmtCreate = new Date();
			gmtModified = gmtCreate;
		}
	}

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public Long getAdminId()
	{
		return adminId;
	}

	public void setAdminId(Long adminId)
	{
		this.adminId = adminId;
	}

	public Long getDeveloperId()
	{
		return developerId;
	}

	public void setDeveloperId(Long developerId)
	{
		this.developerId = developerId;
	}

	public Long getChangeMoney()
	{
		return changeMoney;
	}

	public void setChangeMoney(Long changeMoney)
	{
		this.changeMoney = changeMoney;
	}

	public String getStatus()
	{
		return status;
	}

	public void setStatus(String status)
	{
		this.status = status;
	}

	public String getMessage()
	{
		return message;
	}

	public void setMessage(String message)
	{
		this.message = message;
	}

	public Date getFinishTime()
	{
		return finishTime;
	}

	public void setFinishTime(Date finishTime)
	{
		this.finishTime = finishTime;
	}

	public Date getGmtCreate()
	{
		return gmtCreate;
	}

	public void setGmtCreate(Date gmtCreate)
	{
		this.gmtCreate = gmtCreate;
	}

	public Date getGmtModified()
	{
		return gmtModified;
	}

	public void setGmtModified(Date gmtModified) {
		this.gmtModified = gmtModified;
	}

	public String getMemo()
	{
		return memo;
	}

	public void setMemo(String memo){
		this.memo = memo;
	}

	/**
	 * 重新设置更新标记
	 */
	public void setUpdateAgain(){
		super.toBeUpdate=true;
	}
}
