package cn.com.duiba.developer.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.developer.center.api.domain.dto.DeveloperSubPowerDto;

import java.util.List;

/**
 * Created by sunyan on 2017/12/19.
 */
@AdvancedFeignClient
public interface RemoteDeveloperSubPowerService {
    /**
     * 批量插入子账户权限
     * @param list
     * @return
     */
    int addPowerForDeveloperSub(List<DeveloperSubPowerDto> list);

    /**
     * 删除权限
     * @param developerSubId
     * @return
     */
    int deletePowerForDeveloperSub(Long developerSubId);


    /**
     * 根据developerSubId查询子账户权限
     */
    List<DeveloperSubPowerDto> findByDeveloperSubId(Long developerSubId);

    /**
     * 根据developerSubId，appId查询子账户权限
     */
    List<DeveloperSubPowerDto> findByDeveloperSubIdAndAppId(Long developerSubId,Long appId);

    /**
     * 根据developerSubId，appId,permissionId查询子账户权限
     */
    DeveloperSubPowerDto findByInfo(Long developerSubId,Long appId,Long permissionId);

    /**
     * 根据developerSubId查询子账户拥有权限的appid
     */
    List<Integer> findPowerAppIds(Long developerSubId);
}
