package cn.com.duiba.developer.center.api.remoteservice.floor;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.developer.center.api.domain.dto.AppLayoutBrickDto;
import cn.com.duiba.developer.center.api.domain.dto.AppLayoutDto;
import cn.com.duiba.developer.center.api.domain.paramquery.PageQueryEntity;
import cn.com.duiba.developer.center.api.domain.vo.PaginationVO;
import cn.com.duiba.wolf.dubbo.DubboResult;
import com.alibaba.fastjson.JSONArray;
import com.google.common.base.Optional;
import org.springframework.web.bind.annotation.RequestMapping;

import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * Created by liuyao on 16/7/27.
 */
@AdvancedFeignClient
public interface RemoteAppLayoutService {
    /**
     * 获取系统分页皮肤列表
     * @param params
     * @return
     */
    DubboResult<PaginationVO<AppLayoutBrickDto>> getSystemLayoutPage(PageQueryEntity params);

    /**
     * 获取定制分页皮肤列表
     * @param params
     * @return
     */
    DubboResult<PaginationVO<AppLayoutBrickDto>> getCustomLayoutPage(PageQueryEntity params);

    /**
     * 开发者更新主题色
     * @param appId
     * @param color
     * @return
     */
    DubboResult<Boolean> updateThemeColor(Long appId,String color);

    /**
     * 开发选择使用楼层皮肤
     * @param appId
     * @param skinId
     * @return
     */
    DubboResult<Boolean> devSetSkin(Long appId, Long skinId);

    /**
     * 开发选择使用楼层皮肤
     * @param appId
     * @param skinId
     * @param ignoreFloorIds 需要忽略的楼层Id,忽略的楼层将会出现在楼层待选区
     * @return
     */
    @RequestMapping("devSetSkinWithIgnoreFloorIds")
    DubboResult<Boolean> devSetSkin(Long appId, Long skinId,List<Long> ignoreFloorIds);

    /**
     * [{id:楼层Id,floorType:楼层类型,enable:是否展示}]
     * @param appId
     * @param floorSortList
     * @return
     */
    DubboResult<Boolean> devReSetFloorList(Long appId,JSONArray floorSortList);

    /**
     * 隐藏指定的楼层,将对应楼层的enable变成false
     * @param appId
     * @param floorIds
     * @return
     */
    DubboResult<Integer> closeFloors(Long appId, Set<Long> floorIds);
    /**
     * 根据appId和floorId更新楼层配置
     * 如果楼层配置不存在，则把配置信息写入到developDataShowJson中；如果楼层配置存在，则更新developDataShowJson中的配置信息
     *
     * @author zhanglihui
     * @param appId       app主键
     * @param floorId     楼层ID
     * @param floorConfig 楼层配置，楼层配置，配置项key值参见相应枚举对象 （ActivityFloorConfKeyEnum，CouponFloorConfKeyEnum， SnapUpFloorConfKeyEnum ...）
     * @return 
     * @since JDK 1.6
     */
    DubboResult<Integer> updateDevFloorConfigByAppId(Long appId, Long floorId, Map<String, Object> floorConfig);

    /**
     * 高并发调用接口
     * @param appId
     * @return
     */
    DubboResult<AppLayoutDto> getAppLayout(Long appId);

    /**
     * 找出使用指定皮肤的AppLayoutDto
     * @param skinId
     * @return
     */
    DubboResult<List<AppLayoutDto>> findAppLayoutsUseSkin(Long skinId);

    public AppLayoutBrickDto findCacheAppLayoutBrick(Long id);

    /**
     * 更新模块的权重
     * @param brickId
     * @param payload
     * @return
     */
    public int updateLayoutBrickPayload(Optional<Long> brickId, Optional<Integer> payload);

    /**
     * 更新模块的状态(是否能够被开发者看到)
     * @param brickId
     * @param status
     * @return
     */
    public int updateLayoutBrickShowStatus(Optional<Long> brickId, Optional<Integer> status);

    /**
     * 新建一个模版片段
     * @param appLayoutBrick
     * @author 刘瑶
     */
    public int insert(AppLayoutBrickDto appLayoutBrick);

    /**
     * 更新皮肤信息
     * @param brick
     * @return
     */
    public int updateBrick(AppLayoutBrickDto brick);

    /**
     * 逻辑删除一个模块(给管理员使用)
     * @param brickId
     * @return
     */
    public int updateBrickDelete(Optional<Long> brickId);

}
