package cn.com.duiba.developer.center.api.domain.dto;

import cn.com.duiba.developer.center.api.domain.enums.FloorThemeTypeEnum;

import java.io.Serializable;

import javax.validation.constraints.NotNull;

/**
 * Created by liuyao on 16/9/8.
 */
public class AerosolDto implements CodeDto {

    private static final long serialVersionUID = -7700210456589539593L;

    /**
     * 存在于.duibaconfig文件中的相关键值
     */
    public static final String CONFIG_KEY_IMAGE_LIST = "imageList";
    public static final String CONFIG_KEY_LINK_LIST = "linkList";
    public static final String CONFIG_KEY_HTML = FloorThemeTypeEnum.HTML.getCode();
    public static final String CONFIG_KEY_JS = FloorThemeTypeEnum.JS.getCode();
    public static final String CONFIG_KEY_CSS = FloorThemeTypeEnum.CSS.getCode();
    public static final String CONFIG_KEY_HTML_URL = "htmlUrl";//生成的模板文件链接
    public static final String CONFIG_KEY_JS_URL = "jsUrl";//js压缩文件链接
    public static final String CONFIG_KEY_CSS_URL = "cssUrl";//css压缩文件链接

    private Long id;
    private Boolean isShow;

    @NotNull
    private Long appId;
    private String appName;

    private Long groupId;
    private String groupName;
    @NotNull
    private String md5;
    @NotNull
    private String configUrl;


    public Boolean getShow() {
        return isShow;
    }

    public void setShow(Boolean show) {
        isShow = show;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public String getMd5() {
        return md5;
    }

    public void setMd5(String md5) {
        this.md5 = md5;
    }

    public String getConfigUrl() {
        return configUrl;
    }

    public void setConfigUrl(String configUrl) {
        this.configUrl = configUrl;
    }

    public String getAppName() {
        return appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public Long getGroupId() {
        return groupId;
    }

    public void setGroupId(Long groupId) {
        this.groupId = groupId;
    }
    public String getGroupName() {
        return groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

}
