package cn.com.duiba.developer.center.api.domain.dto.saas;

import java.io.Serializable;
import java.util.Date;

/**
 * @author kimi
 */
public class SaasOrderDto implements Serializable {
    private static final long serialVersionUID = 5454155825314635342L;
    
    /** 
     * 主键 
     **/
    private Long id;
    /** 
     * appID 
     **/
    private Long appId;
    /** 
     * 开发者联系方式 
     **/
    private String phone;
    /** 
     * 开发者姓名 
     **/
    private String devName;
    /** 
     * 功能类型：1，积分商城；2.签到；3：活动；4：皮肤； 
     **/
    private Integer funcType;
    /** 
     * 功能子类型（活动类型，商城皮肤、签到皮肤、活动皮肤） 
     **/
    private Integer funcSubType;
    /** 
     * 关联ID（活动、签到） 
     **/
    private Long funcRelId;
    /** 
     * 订单类型：1：购买；2：续费； 
     **/
    private Integer orderType;
    /** 
     * 订单市场价格,单位(分)
     **/
    private Long orderPrice;
    /**
     * 订单实际价格,单位(分)
     */
    private Long orderActualPrice;
    /**
     * 授权ID 
     **/
    private Long grantId;
    /** 
     * 订单状态：1：处理中；2：通过；3：取消； 
     **/
    private Integer orderStatus;
    /** 
     * 订单终态备注 
     **/
    private String remarkFinalStatus;
    /** 
     * 管理员输入的订单备注 
     **/
    private String remarkAdmin;
    /** 
     * 授权操作者ID（兑吧管理员） 
     **/
    private Long operatorId;
    /** 
     * 授权时间 
     **/
    private Date grantDate;
    /** 
     * 期限类型，1：日；2：周；3：月；4：季度；5：年； 
     **/
    private Integer dateLimitType;
    /** 
     * 购买数量，授权之前管理员可修改 
     **/
    private Integer limitCount;
    /** 
     * 创建时间 
     **/
    private Date gmtCreate;
    /** 
     * 修改时间 
     **/
    private Date gmtModified;

    public Long getOrderActualPrice() {
        return orderActualPrice;
    }

    public void setOrderActualPrice(Long orderActualPrice) {
        this.orderActualPrice = orderActualPrice;
    }
    public void setId(Long value) {
        this.id = value;
    }
    public Long getId() {
        return this.id;
    }
    
    public void setAppId(Long value) {
        this.appId = value;
    }
    public Long getAppId() {
        return this.appId;
    }
    
    public void setPhone(String value) {
        this.phone = value;
    }
    public String getPhone() {
        return this.phone;
    }
    
    public void setDevName(String value) {
        this.devName = value;
    }
    public String getDevName() {
        return this.devName;
    }
    
    public void setFuncType(Integer value) {
        this.funcType = value;
    }
    public Integer getFuncType() {
        return this.funcType;
    }
    
    public void setFuncSubType(Integer value) {
        this.funcSubType = value;
    }
    public Integer getFuncSubType() {
        return this.funcSubType;
    }
    
    public void setFuncRelId(Long value) {
        this.funcRelId = value;
    }
    public Long getFuncRelId() {
        return this.funcRelId;
    }
    
    public void setOrderType(Integer value) {
        this.orderType = value;
    }
    public Integer getOrderType() {
        return this.orderType;
    }
    
    public void setOrderPrice(Long value) {
        this.orderPrice = value;
    }
    public Long getOrderPrice() {
        return this.orderPrice;
    }
    
    public void setGrantId(Long value) {
        this.grantId = value;
    }
    public Long getGrantId() {
        return this.grantId;
    }
    
    public void setOrderStatus(Integer value) {
        this.orderStatus = value;
    }
    public Integer getOrderStatus() {
        return this.orderStatus;
    }
    
    public void setRemarkFinalStatus(String value) {
        this.remarkFinalStatus = value;
    }
    public String getRemarkFinalStatus() {
        return this.remarkFinalStatus;
    }
    
    public void setRemarkAdmin(String value) {
        this.remarkAdmin = value;
    }
    public String getRemarkAdmin() {
        return this.remarkAdmin;
    }
    
    public void setOperatorId(Long value) {
        this.operatorId = value;
    }
    public Long getOperatorId() {
        return this.operatorId;
    }
    
    public void setGrantDate(Date value) {
        this.grantDate = value;
    }
    public Date getGrantDate() {
        return this.grantDate;
    }
    
    public void setDateLimitType(Integer value) {
        this.dateLimitType = value;
    }
    public Integer getDateLimitType() {
        return this.dateLimitType;
    }
    
    public void setLimitCount(Integer value) {
        this.limitCount = value;
    }
    public Integer getLimitCount() {
        return this.limitCount;
    }
    
    public void setGmtCreate(Date value) {
        this.gmtCreate = value;
    }
    public Date getGmtCreate() {
        return this.gmtCreate;
    }
    
    public void setGmtModified(Date value) {
        this.gmtModified = value;
    }
    public Date getGmtModified() {
        return this.gmtModified;
    }
    
    
}

