package cn.com.duiba.developer.center.api.domain.paramquery;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

import cn.com.duiba.developer.center.api.DeveloperCenterException;
import org.apache.commons.lang.StringUtils;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;


/**
 * Created by liuyao on 16/7/29.
 */
public class CreateAppQueryParams implements Serializable{
    private static final long serialVersionUID = -7512381957793791622L;

    public static final Integer CREATE_SOURCE_CREDITS = 0;//商城
    public static final Integer CREATE_SOURCE_AD = 1;//广告

    @NotNull(message = "创建App必须指定开发者")
    private Long developerId;
    @NotNull(message = "App名称不能为空")
    @Size(max = 20,min = 1,message = "App名称最长为20个字符")
    private String name;
    @Min(value = 1,message = "积分汇率必须大于0")
    private Integer creditsRate = 100;
    @NotNull(message = "积分名称不能为空")
    @Size(max = 15,min = 1,message = "积分单位最长15个字符")
    private String unitName = "积分";
    @NotNull(message = "必须指定应用类别")
    private String category = "工具";

    @NotNull(message = "必须指定创建的来源")
    private Integer createSource = CREATE_SOURCE_CREDITS;

    @NotNull
    private Boolean mallCredits = false;//false代表积分商城模式,true代表无积分模式

    private String logo;

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getCreditsRate() {
        return creditsRate;
    }

    public void setCreditsRate(Integer creditsRate) {
        this.creditsRate = creditsRate;
    }

    public String getUnitName() {
        return unitName;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }

    public List<String> getCategory(){
        if(StringUtils.isBlank(category)){
            return Collections.emptyList();
        }
        Splitter spl = Splitter.on(",").limit(2).trimResults().omitEmptyStrings();
        return spl.splitToList(category);
    }

    public void setCategory(String ...category) throws DeveloperCenterException {
        if(category.length>2){
            throw new DeveloperCenterException("应用类别层级最多为两级");
        }
        Joiner joiner = Joiner.on(",").skipNulls();
        this.category = joiner.join(category);
    }

    public Long getDeveloperId() {
        return developerId;
    }

    public void setDeveloperId(Long developerId) {
        this.developerId = developerId;
    }

    public Boolean getMallCredits() {
        return mallCredits;
    }

    public void setMallCredits(Boolean mallCredits) {
        this.mallCredits = mallCredits;
    }

    public Integer getCreateSource() {
        return createSource;
    }

    public void setCreateSource(Integer createSource) {
        this.createSource = createSource;
    }

    public String getLogo() {
        return logo;
    }

    public void setLogo(String logo) {
        this.logo = logo;
    }
}
