package cn.com.duiba.developer.center.api.remoteservice.saas;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.developer.center.api.domain.dto.DeveloperDto;
import cn.com.duiba.developer.center.api.domain.dto.saas.SaasDevFreeDto;
import cn.com.duiba.developer.center.api.domain.paramquery.SaasWhiteListParams;
import cn.com.duiba.developer.center.api.domain.vo.PaginationVO;

/**
 * Created by zyj on 2018/4/7.
 */
@AdvancedFeignClient
public interface RemoteSaasDevFreeService {

    /**
     * 新增白名单
     * @param saasDevFreeDto
     * @return
     */
    boolean insert(SaasDevFreeDto saasDevFreeDto);

    /**
     * 删除白名单
     * @param developerId
     * @return
     */
    boolean delete(Long developerId);

    /**
     * 判断是否已经是白名单
     * @param appId
     * @return
     */
    boolean isExist(Long appId);

    /**
     * 获取白名单列表
     * @param params
     * @return
     */
    PaginationVO<DeveloperDto> findPageList(SaasWhiteListParams params);
}
