
package cn.com.duiba.developer.center.api.remoteservice.statistics;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.developer.center.api.domain.dto.statistics.OdpsActivityWeekMonthUvDto;
import cn.com.duiba.developer.center.api.domain.dto.statistics.OdpsAppActivityDwmStatDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.Date;
import java.util.List;

/**
 * odps活动统计
 * @Author【yaocheng@duiba.com.cn】
 * @Date 2016/11/23 15:57
 */
@AdvancedFeignClient
public interface RemoteOdpsAppActivityDwmStatService {

    /**
     *根据appId、开始日期、结束日期查询每日活动统计数据
     * @param appId
     * @param startDay
     * @param endDay
     * @param orderBy
     * @return
     */
    DubboResult<List<OdpsAppActivityDwmStatDto>> findSumByAppIdAndDayAndOrderBy(Long appId, Date startDay, Date endDay, String orderBy);

    /**
     * 根据活动ID和时间查询周月
     * @param startDay
     * @param endDay
     * @param operatingActivityIds
     * @return
     */
    DubboResult<List<OdpsActivityWeekMonthUvDto>> findWeekAndMonthByOAIdsAndDay(Date startDay, Date endDay, List<Long> operatingActivityIds);

    /**
     * 根据appId和开始日期，结束日期，查询
     * @param appId
     * @param startDay
     * @param endDay
     * @return
     */
     DubboResult<List<OdpsAppActivityDwmStatDto>> findSumByAppIdAndDayBetween(Long appId, Date startDay, Date endDay);
}
