package cn.com.duiba.developer.center.api.domain.enums;


import cn.com.duiba.developer.center.api.DCExceptionCode;
import cn.com.duiba.developer.center.api.DeveloperCenterException;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by xiaoxuda on 2017/7/31.
 */
public enum  AppAccountStatusEnum {
    BalanceNotEnough(DCExceptionCode.BalanceNotEnough, "开发者余额不足", "对不起，没有兑换成功，请挑选其他吧"),
    MonthBudgetNotEnough(DCExceptionCode.BudgetNotEnough, "开发者月预算不足", "对不起，没有兑换成功，请挑选其他吧"),
    DayBudgetNotEnough(DCExceptionCode.BudgetNotEnough, "开发者日预算不足", "对不起，没有兑换成功，请挑选其他吧"),
    BalanceDisabled(DCExceptionCode.BalanceDisabled, "开发者资金账户受限", "正在补仓中，请稍后再试");

    private static Map<String, AppAccountStatusEnum> enumMap = new HashMap<>();
    static{
        for(AppAccountStatusEnum item : AppAccountStatusEnum.values()){
            enumMap.put(item.getCode(), item);
        }
    }

    AppAccountStatusEnum(String code, String desc, String show){
        this.code = code;
        this.desc = desc;
        this.show = show;
    }

    /**
     * 拒绝原因编码，与异常编码统一，
     */
    String code;
    /**
     * 原因描述
     */
    String desc;
    /**
     * UI展示信息
     */
    String show;

    public static AppAccountStatusEnum getByCode(String code){
        AppAccountStatusEnum ret = enumMap.get(code);
        if(ret == null){
            throw new DeveloperCenterException(DCExceptionCode.UnValidParam);
        }
        return ret;
    }

    public String getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public String getShow() {
        return show;
    }
}
