/**
 * Project Name:developer-center-api File Name:RemoteAppBannerService.java Package
 * Name:cn.com.duiba.developer.center.api.remoteservice Date:2016年8月10日下午8:04:14 Copyright (c) 2016, duiba.com.cn All
 * Rights Reserved.
 */

package cn.com.duiba.developer.center.api.remoteservice;

import cn.com.duiba.developer.center.api.domain.dto.AppBannerDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;

/**
 * ClassName:RemoteAppBannerService <br/>
 * appBanner dubbo服务接口
 * Date: 2016年8月10日 下午8:04:14 <br/>
 *
 * @author zhanglihui
 * @see
 * @since JDK 1.6
 */
public interface RemoteAppBannerServiceNew {

    /**
     * 获取的banner和Icon区的AppBannerDto列表
     *
     * @param appId
     * @return
     */
    DubboResult<List<AppBannerDto>> findHomeBannerByCache(Long appId);

    /**
     * 根据id查询banner对象
     *
     * @param id banner主键
     * @return
     * @author zhanglihui
     * @since JDK 1.6
     */
    DubboResult<AppBannerDto> find(Long id);

    /**
     * 获取多个banner
     *
     * @param ids
     * @return
     */
    public DubboResult<List<AppBannerDto>> findAllByIds(List<Long> ids);

    /**
     * 根据主键和appId更新appBanner
     * 所有的写操作都需要带上appId，防止未授权操作
     *
     * @param appBanner banner对象
     * @return
     * @author zhanglihui
     * @since JDK 1.6
     */
    DubboResult<Integer> updateByIdAndAppId(AppBannerDto appBanner);

    /**
     * 根据主键id更新 app banner表
     * @param appBanner
     * @return
     */
    DubboResult<Integer> update(AppBannerDto appBanner);

    /**
     * 根据主键和appId更新appBanner,允许更新活动时间为null
     * 所有的写操作都需要带上appId，防止未授权操作
     *
     * @param appBanner banner对象
     * @return
     * @author zhanglihui
     * @since JDK 1.6
     */
    DubboResult<Integer> updateByIdAndAppIdWithActivityDateNull(AppBannerDto appBanner);

    /**
     * 新增banner
     *
     * @param appBanner banner对象
     * @return
     * @author zhanglihui
     * @since JDK 1.6
     */
    DubboResult<Void> insert(AppBannerDto appBanner);

    /**
     * @param appBanner
     * @return 新Banner的Id
     */
    DubboResult<Long> insertBanner(AppBannerDto appBanner);

    /**
     * 根据appId和类型查询当前最大payload值
     *
     * @param appId app编号
     * @param type  类型 {@link cn.com.duiba.developer.center.api.domain.enums.BannerOrButtonEnum}
     * @return
     * @author zhanglihui
     * @since JDK 1.6
     */
    DubboResult<Integer> findMaxPlayload(Long appId, String type);

    /**
     * 根据appId和deleted标志查询banner列表
     *
     * @param appId   app编号
     * @param deleted 是否删除标志
     * @return
     * @author zhanglihui
     * @since JDK 1.6
     */
    DubboResult<List<AppBannerDto>> findAllByAppId(Long appId, Boolean deleted);

    /**
     * 根据appId、type和deleted标志查询banner列表
     *
     * @param appId   app编号
     * @param type    类型 {@link cn.com.duiba.developer.center.api.domain.enums.BannerOrButtonEnum}
     * @param deleted 是否删除
     * @return
     * @author zhanglihui
     * @since JDK 1.6
     */
    DubboResult<List<AppBannerDto>> findAllByAppIdDeleteAndType(Long appId, String type, Boolean deleted);

    /**
     * sortByBannerIdAndRange:在banner移动范围内排序 <br/>
     * 排序区间为闭区间[startPayload, endPayload]
     *
     * @param appId        app编号
     * @param bannerId     banner编号
     * @param type         类型 banner/button
     * @param startPayload 排序起始payload值
     * @param endPayload   排序结束payload值
     * @return
     * @author zhanglihui
     * @since JDK 1.6
     */
    DubboResult<Void> sortByBannerIdAndRange(Long appId, Long bannerId, String type, Integer startPayload,
                                             Integer endPayload);

    /**
     * 根据appItemId查询banner列表（包含已删除的）
     *
     * @param appId     app编号
     * @param appItemId 开发者商品id
     * @param type      类型 {@link cn.com.duiba.developer.center.api.domain.enums.BannerOrButtonEnum}
     * @return
     * @author zhanglihui
     * @since JDK 1.6
     */
    DubboResult<List<AppBannerDto>> findBannerByItemId(Long appId, Long appItemId, String type);

    /**
     * 根据活动id禁用或启用banner
     *
     * @param delete
     * @param activityId
     * @param type
     * @return
     */
    public DubboResult<Integer> disableByActivityId(Boolean delete, Long activityId, Integer type);

    /**
     * @param appId
     * @param appItemId
     * @return 更新行数
     */
    public DubboResult<Integer> disableByAppIdAndAppItemId(Long appId, Long appItemId);

    /**
     * 根据oaId禁用或者启用banner
     *
     * @param delete
     * @param relationId
     * @return
     */
    DubboResult<Integer> disableByOperatingActivityId(Boolean delete,Long relationId);

    /**
     * 批量根据oaId禁用或者启用banner
     *
     * @param delete
     * @param relationIds
     * @return
     */
    DubboResult<Integer> disableByOperatingActivityIdBatch(Boolean delete, List<Long> relationIds);

    /**
     * 查询
     *
     * @param type
     * @param sourceType
     * @param sourceRelationId
     * @param url
     * @return
     */
    DubboResult<List<AppBannerDto>> findByTypeAndSourceAndSourceIdAndUrl(String type, Integer sourceType, Long sourceRelationId, String url);

    /**
     * 失效以上架的icon
     * @param sourceType
     * @param url
     * @param sourceRelationId
     * @return
     */
    DubboResult<Integer> disableIconBySourceTypeAndUrlAndSourceRelationId(Integer sourceType,String url,
                                                                          Long sourceRelationId);

    /**
     * 根据itemIdList，获取多个banner
     *
     * @param itemIdList
     * @return
     */
    DubboResult<List<AppBannerDto>> findAllByItemIdList(List<Long> itemIdList);

    /**
     * 获取分类icon信息
     * @param appId
     * @param classifyId
     * @return
     */
    DubboResult<List<AppBannerDto>> findIconClassify(Long appId, Long classifyId);


    /**
     * 删除自定义banner
     * @param delete
     * @param relationId
     * @param appId
     * @return
     */
    DubboResult<Integer> deleteByClassify(Boolean delete,Long relationId,Long appId);

    /**
     * 更改banner名称图片
     * @param id
     * @param name
     * @param image
     * @return
     */
    DubboResult<Integer> updateNameImage(Long id, String name, String image);
    /**
     * 批量更新appbanner
     * @param appBanner
     * @return
     */
    DubboResult<Integer> updateBatchByIdAndAppId(List<AppBannerDto> appBanner);

    DubboResult<Integer> disableByAppItemId(Long appItemId);
}
