package cn.com.duiba.developer.center.api.remoteservice;

import cn.com.duiba.developer.center.api.domain.dto.AppBudgetDto;
import cn.com.duiba.developer.center.api.domain.dto.AppManagerDto;
import cn.com.duiba.developer.center.api.domain.dto.AppSimpleDto;
import cn.com.duiba.developer.center.api.domain.dto.app.TuiaAppDto;
import cn.com.duiba.developer.center.api.domain.paramquery.*;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;
import java.util.Map;

/**
 * Created by liuyao on 16/7/29.
 */
public interface RemoteAppService {
    /**
     * 创建App,注册时请不要调此服务,因为注册服务会自动完成app的创建
     *
     * @param param
     * @return
     */
    DubboResult<Long> createApp(CreateAppQueryParams param);

    /**
     * 获取App简单字段(可高并发)
     *
     * @param id
     * @return
     */
    DubboResult<AppSimpleDto> getSimpleApp(Long id);

    /**
     * 批量获取App简单字段
     *
     * @param id
     * @return
     */
    DubboResult<List<AppSimpleDto>> getSimpleAppByIds(List<Long> id);

    /**
     * 获取app预算
     *
     * @param id
     * @return
     */
    DubboResult<AppBudgetDto> getAppBudget(Long id);

    /**
     * 更新应用配置信息
     *
     * @param params
     * @return
     */
    @Deprecated
    DubboResult<Boolean> updateAppInfo(AppInfoFromParams params);

    /**
     * app接口配置
     *
     * @param appUrlParams
     * @return
     */
    DubboResult<Boolean> updateApiConfig(AppUrlParams appUrlParams);

    /**
     * app预算配置
     *
     * @param appBudget
     * @return
     */
    DubboResult<Boolean> updateBudgetConfig(AppBudget4Update appBudget);

    /**
     * 更新app配置
     *
     * @param appExtraParams
     */
    void saveAppConfig(AppExtraParams appExtraParams);

    /**
     * 通过appKey查询app
     *
     * @param appKey
     * @return
     */
    DubboResult<AppSimpleDto> getAppByAppKey(String appKey);

    /**
     * 通过开发者ID查询app的信息
     *
     * @param developerId
     * @return
     */
    DubboResult<List<AppSimpleDto>> findAllByDeveloper(Long developerId);

    /**
     * 根据应用名称查询(前模糊)app的信息
     *
     * @param appName 应用名称
     * @return
     */
    DubboResult<List<AppSimpleDto>> findAppNameByNameLike(String appName);

    /**
     * 根据应用名称模糊查询前20条
     *
     * @param appName 应用名称
     * @return
     */
    DubboResult<List<AppSimpleDto>> findAppByAppName(String appName);

    /**
     * 根据定向列表和黑名单列表查询app信息
     *
     * @param specifyAppIds 定向appId列表
     * @param blackDevIds   黑名单开发者Id列表
     * @return
     */
    DubboResult<List<AppSimpleDto>> findAppBySpecifyAndBlack(List<Long> specifyAppIds, List<Long> blackDevIds);

    /**
     * 根据enable appType appname和email进行分页查询
     *
     * @param queryMap
     * @return
     */
    DubboResult<List<AppManagerDto>> findAppListByCondition(Map<String, Object> queryMap);

    /**
     * 根据enable appType appname和email进行查询总数
     *
     * @param queryMap
     * @return
     */
    DubboResult<Integer> findAppListCount(Map<String, Object> queryMap);

    /**
     * 查询app信息
     *
     * @param appIds
     * @return
     */
    DubboResult<List<AppManagerDto>> findByAppIdsManagerDto(List<Long> appIds);

    /**
     * 扣除预算，用于创建订单流程中
     */
    DubboResult<Boolean> deductBudget(AppBudgetParam param);

    /**
     * 返还预算
     */
    DubboResult<Boolean> restoreBudget(AppBudgetParam param);

    /**
     * 更新app开关状态
     * @param appSwtichParam
     * @return
     */
    DubboResult<Boolean> updateAppSwitch(AppSwitchParam appSwtichParam);

    /**
     * 更新app信息，开发者后台与管理端调用
     * @param app
     * @return
     */
    DubboResult<Boolean> updateAppInfo(AppSimpleDto app);


    /**
     * 广告平台调用
     * 获取最大和最小appIid
     * key:maxId,minId
     * @return，
     */
    DubboResult<Map<String,Long>> getMaxMinAppId();

    /**
     * 广告平台调用
     * 分批次获取兑吧App数据
     * @param minId 开始ID
     * @param maxId 结束ID
     * @return
     */
    DubboResult<List<TuiaAppDto>> getDuiBaAppData(Long minId, Long maxId);

    /**
     * @param specifyAppIds 定向的appIds
     * @param blackAppIds 黑名单appIds
     * @return
     */
    DubboResult<List<AppSimpleDto>> findAllBySpecifyAndBlack(List<Long> specifyAppIds, List<Long> blackAppIds);

    /**
     *
     * @param itemIdMap: key: itemId, value: appIdList
     * @return
     */
    DubboResult<Map<Long, Integer>> countItemAutoRecommandApp(Map<Long, List<Long>> itemIdMap);

    /**
     *
     * @param appIds
     * @return
     */
    DubboResult<List<Long>> getAutoRecommandAppIdListByAppId(List<Long> appIds);

    /**
     * 根据开发者id集合获取对应的所有appId
     * @param developerIds
     * @return
     */
    List<Long> findAllAppIdsByDevelopIds(List<Long> developerIds);

}
