/**
 * Project Name:developer-center-api
 * File Name:RemoteOdpsAppDailyStatService.java
 * Package Name:cn.com.duiba.developer.center.api.remoteservice.statistics
 * Date:2016年11月23日下午2:26:28
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.developer.center.api.remoteservice.statistics;

import java.util.Date;
import java.util.List;

import cn.com.duiba.developer.center.api.domain.dto.statistics.OdpsAppDailyStatDto;
import cn.com.duiba.wolf.dubbo.DubboResult;


/**
 * app每日访问量离线数据统计接口<br/>
 * Date:     2016年11月23日 下午2:26:28 <br/>
 * @author   zhanglihui
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
public interface RemoteOdpsAppDailyStatService {
    /**
     * 根据App和时间区间查询，根据统计日期升序排序
     * @param appId
     * @param start
     * @param end
     * @return
     */
    DubboResult<List<OdpsAppDailyStatDto>> findStatByAppIdAndDayBetween(Long appId, Date start, Date end);
}

