package cn.com.duiba.developer.center.api.utils;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;

import java.util.Arrays;
import java.util.List;
import java.util.Set;

/**
 * 一些需要定制的App的ID集合
 * @author xuhengfei
 * --------------------------不要用List,List.contains检索速度没有Set.contains快---------------------
 */
public class AppIdConstant {

	//==================================静态变量==========================================
	
	/**
	 * 直充接口下单白名单，仅这些app提供接口兑换。
	 */
	private static final List<Long> ChargeAppWhiteList=Arrays.asList(1L,22L,45L,61L,118L,122L,126L,158L,175L,259L,291L,543L,1108L,1216L,1871L);
	
	/**
	 * 是否使用500格式的页面（首页+商品详情页+兑换记录页）
	 * 购时光，格瓦拉，大姨吗（4437L），典典养车/典典养车测试（4358L,4732L） 
	 * 58同城加入500页面（4515,5183），恋爱记（5281L），野夫钓鱼（4947L），爱阅读（3647L）
	 */
	private static final List<Long> Use500PageApps=Arrays.asList(129L,1609L,1915L,2264L,2064L,1452L,100L,7L,9L,2842L,3324L,4437L,4358L,4732L,4515L,5183L,4902L,5281L,4947L,3647L);
	
	/**
	 * 百度正式+测试环境
	 */
	private static final List<Long> BaiduApps=Arrays.asList(7L,9L);
	
	/**
	 * 百度需要安全初始化客户端js接口
	 * 所有与客户端交互的js代码不变，都需要先通过初始化js让客户端注册方法。
	 */
	private static final List<Long> BaiduClientJSInvokeApps=Arrays.asList(7L,9L,513L);

	/**
	 * 饿了么ID
	 */
	private static final List<Long> ELE_APPIDS = Arrays.asList(14695L);

	/**
	 * 秒杀商品免校验app
	 */
	private static final List<Long> secKillSkipApps=Arrays.asList(491L,3862L);
	
	/**
	 * 网赚客户部分老机型适配有问题，返回使用老页面（直冲类详情页）
	 * 零花:352、马上赚钱:29,255、口袋ATM:842、试货:166、口袋赚钱:902、口袋ATM（android）:904、无聊赚：1030、IOS_口袋ATM:1507、有钱APP:1204、快来赚钱724
	 * 口袋赚：1820、钱鹿锁屏：1553、蛋蛋赚：2210
	 */
	private static final List<Long> useOldPage=Arrays.asList(352L,29L,255L,842L,166L,902L,904L,1031L,1507L,1204L,724L,915L,1553L,1820L,2210L);
	
	/**
	 * 取消banner上传大小限制
	 * 目前只有赶集：2264L,2064L
	 */
	private static final List<Long> cancelBannerSizeLimit = Arrays.asList(2264L,2064L);
	
	/**
	 * 虚拟商品（绑定AppId和商品id），如果为未绑定QQ号的用户，按钮提示去绑定QQ。
	 * 迅雷：4391L
	 */
	private static final List<Long> VirtualGoBindQQAppList=Arrays.asList(4391L);
	
	/**
	 * 兑吧优惠券在兑换成功后，兑换成功通知页、领奖成功通知页、兑换记录详情页是否展示马上使用的按钮
	 * 赶集:2264L,2064L ||  58同城:4515   ||  PPTV:4688 || 360手机助手:10935
	 */
	public static final ImmutableSet<Long> showUseButton = ImmutableSet.of(2264L,2064L,4515L,5183L,4688L,2516L,4437L,6839L,4786L,9438L,8786L,10935L,11150L,7433L,15160L,16101L,12091L,17509L);
	
	/**
	 * 新浪定制meta分享信息。
	 */
	private static final List<Long> shareMeta4Sina = Arrays.asList(4899L);
	
	/**
	 * Camera360  appId
	 */
	private static final List<Long> Camera360List = Arrays.asList(7553L,7591L);
	
	
	/**
	 * weibo  appId
	 */
	private static final List<Long> WeiboList = Arrays.asList(7585L,5606L);
	
	/**
	 * qq浏览器
	 * fxt 2016-03-14
	 */
	private static final List<Long> qqBrowserList = Arrays.asList(9454L,9505L);

	/**
	 * 腾讯手机QQ浏览器
	 * 腾讯手机QQ浏览器-iOS
	 * 给app切换用
	 * zjd 2016-08-30
	 */
	private static final List<Long> qqBrowserList4Switch = Arrays.asList(9454L,14450L);

	
	/**
	 * 未知APP
	 */
	private static final List<Long> otherAppList = Arrays.asList(6002L,5734L);
	/**
	 * 有道云词典
	 * fxt 2016-03-31
	 */
	private static final List<Long> youDaoYunList = Arrays.asList(10511L,9464L);
	
	
	/**
	 * 不展示积分的APP
	 * 百度贴吧:10379
	 */
	public static final ImmutableSet<Long> dontshowCreditsAppIds = ImmutableSet.of(11056L);

	public static final ImmutableSet<Long> mobikeAppIds=ImmutableSet.of(33888L,28651L,35830L);//35830L 摩拜测试应用，33888L摩拜正式应用

	public static final ImmutableSet<Long> alisportsIds=ImmutableSet.of(21394L,36558L);


	private AppIdConstant(){}
	
	//==================================静态方法==========================================
	
	
	public static boolean showCredits(Long appId){
		return !dontshowCreditsAppIds.contains(appId);
	}
	
	/**
	 * 直充类接口限制，将目前正在使用的app加入白名单，后续不再对新增的app提供直充接口功能。
	 * 该白名单列表为 4月12日-5月12日一个月内使用直充类接口的appId。
	 * @author fxt 2015年5月13日 下午8:20:17
	 */
	public static List<Long> getChargeAppWhiteList(){
		return ChargeAppWhiteList;
	}
	
	/**
	 * 是否使用500格式的页面（首页+商品详情页+兑换记录页）
	 * 购时光，格瓦拉
	 */
	public static boolean isUse500Page(Long appId){
		return Use500PageApps.contains(appId);
	}
	
	/**
	 * 是否展示第三方发货，目前格瓦拉提这个要求
	 * @param appId
	 * @return
	 */
	public static boolean isShow3SendObject(Long appId){
		if(show3SendObject.contains(appId)){
			return true;
		}
		return false;
	}
	
	private static final List<Long> show3SendObject=Arrays.asList(1609L);
	
	/**
	 * 网赚客户部分老机型适配有问题，返回使用老页面
	 * @author fxt 2015年5月22日 下午2:27:41
	 */
	public static boolean useOldPage(Long appId){
		return useOldPage.contains(appId);
	}

	public static boolean isEleApp(Long appId){
		return ELE_APPIDS.contains(appId);
	}

	/**
	 * 判断是百度APPID
	 */
	public static boolean isBaiduApp(Long appId){
		if(BaiduApps.contains(appId)){
			return true;
		}
		return false;
	}
	
	/**
	 * 判断是百度测试环境APPID
	 */
	public static boolean isBaiduClientJSInvoke(Long appId){
		if(BaiduClientJSInvokeApps.contains(appId)){
			return true;
		}
		return false;
	}
	

	/**
	 * 判断是秒杀免验证码APPID
	 */
	public static boolean isSecKillSkipApp(Long appId){
		if(secKillSkipApps.contains(appId)){
			return true;
		}
		return false;
	}
	
	/**
	 * 在兑换记录页最下面的 “已经没有更多了！”替换成app的链接
	 * 目前是赶集网的需求
	 */
	public static boolean isGanjiShowMoreHistory(Long appId) {
		if (ganjiShowMoreHistory.contains(appId)) {
			return true;
		}
		return false;
	}

	private static final List<Long> ganjiShowMoreHistory = Arrays.asList(2264L,2064L);
	
	
	
	/**
	 * 取消banner上传大小限制
	 * 目前只有赶集
	 */
	public static boolean isCancelBannerSizeLimit(Long appId) {
		if (cancelBannerSizeLimit.contains(appId)) {
			return true;
		}
		return false;
	}
	
	/**
	 * 虚拟商品（绑定商品id），如果为未绑定QQ号的用户，按钮提示去绑定QQ。
	 * @author fxt 2015年9月9日 下午3:20:17
	 */
	public static boolean isVirtualGoBindQQApp(Long appId){
		return VirtualGoBindQQAppList.contains(appId);
	}
	
	/**
	 * 新浪新闻分享meta信息定制。
	 * @author fxt 2015年9月29日 下午1:20:17
	 */
	public static boolean isShareMeta4Sina(Long appId){
		return shareMeta4Sina.contains(appId);
	}
	/***用来判断是不是58同城的APP，如果是，在用户没有登录的情况下，调用58那边的JS脚本，跳转到58的登录首页***/
	public static boolean is58App(Long appId)
	{
		if (Objects.equal(4515L, appId) || Objects.equal(5183L, appId))
		{
			return true;
		}
		return false;

	}
	
	public static boolean isPPTVApp(Long appId){
		if(Objects.equal(4688L, appId)){
			return true;
		}
		return false;
		
	}

	private static final List<Long> DownloadUrlToTextList = Arrays.asList(4515L, 5183L,4688L,4714L,2516L,4437L,6839L,5965L,4786L,9438L,8786L,10935L,11150L,7433L,15160L,16101L,12091L,17509L);

	/**
	 * 下载链接在展示的时候，个别app中需要展示纯文本
	 */
	public static boolean isDownloadUrlShowText(Long appId) {
		return DownloadUrlToTextList.contains(appId);
	}
	
	private static final List<Long> TianyiList = Arrays.asList(472L);
	
	/**
	 * 天翼阅读
	 */
	public static boolean isTianyiList(Long appId) {
		return TianyiList.contains(appId);
	}

	/**
	 * 为爱卡无线
	 */
	public static boolean isAikaApp(Long appId) {
		if(Objects.equal(5837L, appId)){
			return true;
		}
		return false;
	}
	
	/**
	 * Camera360收货地址反填定制
	 */
	public static boolean isCamera360(Long appId) {
		return Camera360List.contains(appId);
	}
	
	/**
	 * sina weibo
	 */
	public static boolean isWeibo(Long appId) {
		return WeiboList.contains(appId);
	}


	private static final List<Long> baoFeng = Arrays.asList(2842L);
	
	public static boolean isBaoFengApp(Long appId) {
		if (baoFeng.contains(appId)) {
			return true;
		}
		return false;
	}
	
	/**
	 * 判断是否是qq浏览器
	 */
	public static boolean isQqBrowserList(Long appId) {
		return qqBrowserList.contains(appId);
	}
	/**
	 * 判断是否是qq浏览器,给app切换用
	 */
	public static boolean isQqBrowserList4Switch(Long appId) {
		return qqBrowserList4Switch.contains(appId);
	}

	public static boolean isOtherAppList(Long appId){
		return otherAppList.contains(appId);
	}
	 /****
     * 有道云定制
     * @param appId  测试包： 10511  正式包：9464L
     * @return
     */
    public static boolean isUDaoYun(Long appId)    {
        return youDaoYunList.contains(appId);
    }
    
    /**
     * in 的APPID
     */
    private static final List<Long> isINAppids = Arrays.asList(4511L);
	
	public static boolean isIn(Long appId) {
		if (isINAppids.contains(appId)) {
			return true;
		}
		return false;
	}
	/****
	 * 手工客APPID
	 */
   private static final List<Long> isShouGongKe = Arrays.asList(10241L);
	
	public static boolean isShouGongKe(Long appId) {
		if (isShouGongKe.contains(appId)) {
			return true;
		}
		return false;
	}
	
	/****
	 * 凤凰新闻
	 */
   private static final List<Long> ifengList = Arrays.asList(6002L,5734L);
	
	public static boolean isIfeng(Long appId) {
		if (ifengList.contains(appId)) {
			return true;
		}
		return false;
	}
	
	/****
	 * 微家园测试环境
	 */
   private static final List<Long> weiJiaYuanTestList = Arrays.asList(11022L);
	
	public static boolean isWeiJiaYuanTestList(Long appId) {
		if (weiJiaYuanTestList.contains(appId)) {
			return true;
		}
		return false;
	}
	
	/****
	 * 微家园正式环境
	 */
   private static final List<Long> weiJiaYuanList = Arrays.asList(11150L);
	
	public static boolean isWeiJiaYuanList(Long appId) {
		if (weiJiaYuanList.contains(appId)) {
			return true;
		}
		return false;
	}
	
	/****
	 * 她社区
	 */
   private static final List<Long> tashequ = Arrays.asList(5320L);
	
	public static boolean isTashequ(Long appId) {
		if (tashequ.contains(appId)) {
			return true;
		}
		return false;
	}
	/**
	 * 是否贴吧应用
	 * @param appId
	 * @return
	 */
	public static final boolean isBaiduTiebaApp(Long appId){
		return appId.equals(11056L);
	}
	
	/****
	 * 爱学贷
	 */
	private static final List<Long> aixuedaiList = Arrays.asList(9877L);
	
	public static boolean isAixuedai(Long appId) {
		if (aixuedaiList.contains(appId)) {
			return true;
		}
		return false;
	}

	/**
	 * oppo 新
	 */
	private static final List<Long> oppoNew = Arrays.asList(11083L);

	public static boolean isOppoNew(Long appId) {
		if (oppoNew.contains(appId)) {
			return true;
		}
		return false;
	}

	/****
	 * 金立 定制 11108
	 */
	private static final List<Long> jinliList = Arrays.asList(11108L);
	
	public static boolean isJinli(Long appId) {
		if (jinliList.contains(appId)) {
			return true;
		}
		return false;
	}

	/****
	 * 乐视 定制 10736   &&  51信用 14773  隐藏兑换入口
	 */

	private static final List<Long> leshiList = Arrays.asList(10736L,14773L,16101L);
	
	public static boolean isLeshi(Long appId) {
		if (leshiList.contains(appId)) {
			return true;
		}
		return false;
	}

	/****
	 * wps 定制 14884l
	 */
	private static final List<Long> wspList = Arrays.asList(14884l);

	public static boolean  isWps(Long appId) {
		if (wspList.contains(appId)) {
			return true;
		}
		return false;
	}
	
	/****
	 * 祺天贷定制 14895l
	 */
	private static final List<Long> qiTianDaiList = Arrays.asList(14895l);

	public static boolean  isQiTianDai(Long appId) {
		if (qiTianDaiList.contains(appId)) {
			return true;
		}
		return false;
	}

	/****
     * 不需要 进行token 校验
     */
    private static final List<Long> tokenList = Arrays.asList(16689L,19780L,14842L);

    public static boolean  isNotNeedTokenCheck(Long appId) {
        if (tokenList.contains(appId)) {
            return false;
        }
        return true;
    }

	/**
	 * 微糖appId,（目前用户兑换记录页，更多历史记录链接定制）
	 */
	private static final Set<Long> wellTangAppIdSet = Sets.newHashSet(24875L,24730L);

	public static boolean wellTangAppId(Long appId){
		return wellTangAppIdSet.contains(appId);
	}

	/**
	 *
	 * @return
     */
	public static boolean isMoBike(Long appId){
		return mobikeAppIds.contains(appId);
	}

	/**
	 *
	 * @return
	 */
	public static boolean isAlisports(Long appId){
		return alisportsIds.contains(appId);
	}

}
