/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.developer.center.api.utils;

import cn.com.duiba.developer.center.api.domain.dto.DomainConfigDto;
import cn.com.duiba.developer.center.api.remoteservice.RemoteDomainConfigService;
import com.google.common.base.Optional;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationDomainUtil {
    private static Logger logger = LoggerFactory.getLogger(ApplicationDomainUtil.class);
    private static RemoteDomainConfigService remoteDomainConfigService;
    private static final Cache<Long, Optional<DomainConfigDto>> LOCAL_DOMAIN_CACHE;
    private static String appHomeDomain;
    private static String appSeckillDomainName;
    private static String appGoodsDomainName;
    private static String appActDomainName;
    private static String appTradeDomainName;
    private static String appTuiaDomainName;
    private static String appEmbedDomain;

    private static DomainConfigDto getApplicationDomainConfig(Long appId) {
        if (appId == null) {
            return ApplicationDomainUtil.getLocalConfig();
        }
        try {
            Optional domainOpt = (Optional)LOCAL_DOMAIN_CACHE.get((Object)appId, () -> Optional.fromNullable((Object)remoteDomainConfigService.findDomainConfig(appId).getResult()));
            if (domainOpt == null && domainOpt.orNull() != null) {
                return (DomainConfigDto)domainOpt.orNull();
            }
            DomainConfigDto domain = ApplicationDomainUtil.getLocalConfig();
            LOCAL_DOMAIN_CACHE.put((Object)appId, (Object)Optional.fromNullable((Object)domain));
            return domain;
        }
        catch (ExecutionException e) {
            logger.error("\u83b7\u53d6\u5e94\u7528\u57df\u540d\u914d\u7f6e\u5931\u8d25,\u964d\u7ea7\u53d6\u672c\u5730\u914d\u7f6e", (Throwable)e);
            return ApplicationDomainUtil.getLocalConfig();
        }
    }

    private static DomainConfigDto getLocalConfig() {
        DomainConfigDto domainConfig = new DomainConfigDto();
        domainConfig.setActivityDomain(appActDomainName);
        domainConfig.setHomeDomain(appHomeDomain);
        domainConfig.setGoodsDomain(appGoodsDomainName);
        domainConfig.setSeckillDomain(appSeckillDomainName);
        domainConfig.setTradeDomain(appTradeDomainName);
        domainConfig.setTuiaDomain(appTuiaDomainName);
        domainConfig.setEmbedDomain(appEmbedDomain);
        return domainConfig;
    }

    public static void setRemoteDomainConfigService(RemoteDomainConfigService remoteDomainConfigService) {
        ApplicationDomainUtil.remoteDomainConfigService = remoteDomainConfigService;
    }

    public static String getAppHomeDomain(Long appId) {
        return ApplicationDomainUtil.getApplicationDomainConfig(appId).getHomeDomain();
    }

    public static void setAppHomeDomain(String appHomeDomain) {
        ApplicationDomainUtil.appHomeDomain = appHomeDomain;
    }

    public static String getAppSeckillDomainName(Long appId) {
        return ApplicationDomainUtil.getApplicationDomainConfig(appId).getSeckillDomain();
    }

    public static void setAppSeckillDomainName(String appSeckillDomainName) {
        ApplicationDomainUtil.appSeckillDomainName = appSeckillDomainName;
    }

    public static String getAppGoodsDomainName(Long appId) {
        return ApplicationDomainUtil.getApplicationDomainConfig(appId).getGoodsDomain();
    }

    public static void setAppGoodsDomainName(String appGoodsDomainName) {
        ApplicationDomainUtil.appGoodsDomainName = appGoodsDomainName;
    }

    public static String getAppActDomainName(Long appId) {
        return ApplicationDomainUtil.getApplicationDomainConfig(appId).getActivityDomain();
    }

    public static void setAppActDomainName(String appActDomainName) {
        ApplicationDomainUtil.appActDomainName = appActDomainName;
    }

    public static String getAppTradeDomainName(Long appId) {
        return ApplicationDomainUtil.getApplicationDomainConfig(appId).getTradeDomain();
    }

    public static void setAppTradeDomainName(String appTradeDomainName) {
        ApplicationDomainUtil.appTradeDomainName = appTradeDomainName;
    }

    public static String getAppTuiaDomainName(Long appId) {
        return ApplicationDomainUtil.getApplicationDomainConfig(appId).getTuiaDomain();
    }

    public static void setAppTuiaDomainName(String appTuiaDomainName) {
        ApplicationDomainUtil.appTuiaDomainName = appTuiaDomainName;
    }

    public static String getAppEmbedDomain(Long appId) {
        return ApplicationDomainUtil.getApplicationDomainConfig(appId).getEmbedDomain();
    }

    public static void setAppEmbedDomain(String appEmbedDomain) {
        ApplicationDomainUtil.appEmbedDomain = appEmbedDomain;
    }

    static {
        LOCAL_DOMAIN_CACHE = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.MINUTES).maximumSize(2000L).build();
    }
}

