package cn.com.duiba.developer.center.api.domain.enums.saas;

import java.util.Date;

/**
 * @author zhenghuan (zhenghuan@duiba.com.cn)
 * @version Created by zhenghuan on 2018/5/10 0010
 */
public enum SaasInvitCodeStatusEnum {
    INACTIVE("1", "未激活"),
    ACTIVE("2", "已激活"),
    //数据库无此状态
    INVALID("3", "失效");

    public String value;
    public String desc;

    private SaasInvitCodeStatusEnum(String value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    /**
     * 翻译
     * 1.数据库不会保持3状态，3状态通过时间来判断
     *
     * @param createTime
     * @return
     */
    public static String getDesc(String value, Date createTime) {
        if (isActive(value)) {
            return ACTIVE.desc;
        }

        if (isInvalid(value, createTime)) {
            return INVALID.desc;
        }

        return INACTIVE.desc;
    }

    public static boolean isActive(String value) {
        return ACTIVE.value.equals(value);
    }

    /**
     * 判断是否失效
     * 1.未激活的情况下，创建时间超过三十天
     *
     * @param createTime 创建时间，不能为空
     * @return
     */
    public static boolean isInvalid(String value, Date createTime) {
        return INACTIVE.value.equals(value)
                && System.currentTimeMillis() - 30L * 24 * 60 * 60 * 1000 > createTime.getTime();
    }

}
