package cn.com.duiba.developer.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.developer.center.api.domain.dto.appextra.AppConfigDto;
import cn.com.duiba.developer.center.api.domain.dto.appextra.AppExtraDto;
import cn.com.duiba.developer.center.api.domain.dto.appextra.DuibaShareDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;

/**
 * Created by liuyao on 2016/10/12.
 */
@AdvancedFeignClient
public interface RemoteAppExtraService {
    /**
     * 加积分接口
     * @param appId
     * @return
     */
    DubboResult<String> findAppAddCreditsUrlByAppId(Long appId);

    /**
     * 获取唤起登录代码
     * @param appId
     * @return
     */
    DubboResult<String> findCallLoginProgramByAppId(Long appId);

    /**
     * 查询对吧分享信息
     * @param appId
     * @return
     */
    DubboResult<DuibaShareDto> findDuibaShareByAppId(Long appId);

    /**
     * 查询分享代码
     * findShareProgramByAppId:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @author liyang
     * @param appId
     * @return
     * @since JDK 1.6
     */
    DubboResult<String> findShareProgramByAppId(Long appId);

    /**
     * 获取告警电话
     * @param appId
     * @return
     */
    DubboResult<String> findAlarmPhone(Long appId);

    /**
     * 获取nav导航栏代码
     * @param appId
     * @return
     */
    DubboResult<String> findNavProgram(Long appId);

    /**
     * 获取app定制的配置信息
     * @param appId
     * @return
     */
    DubboResult<AppConfigDto> findAppConfigDto(Long appId);
    
    
    DubboResult<AppExtraDto> findByAppIdIfNullAutoCreate(Long appId);
    
    DubboResult<Integer> update(AppExtraDto appExtraDto);
    
    DubboResult<Long> insert(AppExtraDto appExtraDto);
    
    DubboResult<AppExtraDto> findByAppId(Long appId);

    public int updateAppPerson(Long appId,String appPerson);

    public int updateAppType(Long appId,String appType);

    public List<Long> findByAppPersonAndType(String name, String appType);

    public List<AppExtraDto> findByAppIds(List<Long> appIds);
}
