package cn.com.duiba.developer.center.api.domain.paramquery;

import java.io.Serializable;

import cn.com.duiba.developer.center.api.DeveloperCenterException;
import com.google.common.base.Objects;
import org.apache.commons.lang.StringUtils;

import cn.com.duiba.developer.center.api.domain.dto.AmbDeveloperWithdrawCashAuditDto;
import cn.com.duiba.developer.center.api.utils.ParamEstimateUtils;

/**
 * Created by liuyao on 2016/12/06.
 */
public class WithdrawCashParams implements Serializable {

    private static final long serialVersionUID = 4184479799430573797L;
    private Long developerId;

    private String cashType;//提现类型
    
    private String natureType;//收款类型，个人/企业

    private String businessLicencePic;//营业执照

    private String idCardFrontPic;//身份证正面

    private String idCardBackPic;//身份证反面

    private String bank;//银行

    private String bankProvince;//银行所在省

    private String bankCity;//银行所在市

    private String bankBranchName;//分行名称

    private String bankAccountNumber;//银行帐户

    private String bankAccountName;//银行帐户开户名称

    private String alipayAccountNumber;//支付宝帐户

    private String alipayAccountName;//支付宝帐户名称

    private String registerEmail;//注册邮箱

    private String phone;//手机号
    
    private String money;

    private Long auditId;
    
    private String phoneCode;//手机验证码
    
    private String emailCode;//邮箱验证码
    
    private String token; //表单token

    /**
     * 验证表单合法性
     * @throws DeveloperCenterException
     */
    public void verify() throws DeveloperCenterException{
        if(StringUtils.isBlank(cashType)){
            throw new DeveloperCenterException("提现类型不能为空");
        }
        if(!Objects.equal(cashType,AmbDeveloperWithdrawCashAuditDto.CashTypeAliPay) &&
                !Objects.equal(cashType,AmbDeveloperWithdrawCashAuditDto.CashTypeBank)
                     && !Objects.equal(cashType,AmbDeveloperWithdrawCashAuditDto.CashTypeRemaining)){
            throw new DeveloperCenterException("提现类型不正确");
        }

        if(auditId != null){
            return;
        }
        if(!ParamEstimateUtils.isValid(bankBranchName)
                || !ParamEstimateUtils.isValid(alipayAccountName)
                || !ParamEstimateUtils.isValid(bankAccountName)){
            throw new DeveloperCenterException("包含非法字符");
        }
        if (Objects.equal(cashType,AmbDeveloperWithdrawCashAuditDto.CashTypeAliPay)) {
            validAlipayInfo();
        } else if (Objects.equal(cashType,AmbDeveloperWithdrawCashAuditDto.CashTypeBank)) {
            validBankInfo();
        }

        validCard();

        validRemain();

    }

    /**
     * 证件验证
     */
    private void validCard(){
        if (Objects.equal(natureType,AmbDeveloperWithdrawCashAuditDto.TypeCompany)) {
            if (StringUtils.isBlank(businessLicencePic)) {
                throw new DeveloperCenterException("企业营业执照不能为空");
            }
            this.idCardFrontPic = null;
            this.idCardBackPic = null;
        } else if (Objects.equal(natureType,AmbDeveloperWithdrawCashAuditDto.TypePersonal)) {
            if (StringUtils.isBlank(idCardFrontPic)) {
                throw new DeveloperCenterException("身份证正面照不能为空");
            }
            if (StringUtils.isBlank(idCardBackPic)) {
                throw new DeveloperCenterException("身份证背面照不能为空");
            }
            this.businessLicencePic = null;
        }
    }

    /**
     * 支付宝信息验证
     */
    private void validAlipayInfo(){
        if (StringUtils.isBlank(natureType)) {
            throw new DeveloperCenterException("类型不能为空");
        }
        if (!Objects.equal(natureType,AmbDeveloperWithdrawCashAuditDto.TypeCompany)
                && !Objects.equal(natureType,AmbDeveloperWithdrawCashAuditDto.TypePersonal)) {
            throw new DeveloperCenterException("类型不正确");
        }
        if (StringUtils.isBlank(alipayAccountNumber)) {
            throw new DeveloperCenterException("支付宝帐户不能为空");
        }
        if (StringUtils.isBlank(alipayAccountName)) {
            throw new DeveloperCenterException("收款人不能为空");
        }
    }

    /**
     * 银行信息验证
     */
    private void validBankInfo(){
        if (StringUtils.isBlank(natureType)) {
            throw new DeveloperCenterException("类型不能为空");
        }
        if (!Objects.equal(natureType,AmbDeveloperWithdrawCashAuditDto.TypeCompany)
                && !Objects.equal(natureType,AmbDeveloperWithdrawCashAuditDto.TypePersonal)) {
            throw new DeveloperCenterException("类型不正确");
        }
        if (StringUtils.isBlank(bank)) {
            throw new DeveloperCenterException("开户行不能为空");
        }
        if (StringUtils.isBlank(bankProvince)) {
            throw new DeveloperCenterException("开户行所在省份/直辖市不能为空");
        }
        if (StringUtils.isBlank(bankCity)) {
            throw new DeveloperCenterException("开户行所在城市/行政区不能为空");
        }
        if (StringUtils.isBlank(bankBranchName)) {
            throw new DeveloperCenterException("开户支行名称不能为空");
        }
        if (StringUtils.isBlank(bankAccountNumber)) {
            throw new DeveloperCenterException("银行卡卡号不能为空");
        }
        if (StringUtils.isBlank(bankAccountName)) {
            throw new DeveloperCenterException("银行卡开户人姓名不能为空");
        }
    }

    /**
     * 余额支付条件验证
     */
    private void validRemain(){
        if(!Objects.equal(cashType,AmbDeveloperWithdrawCashAuditDto.CashTypeRemaining)){
            if(!ParamEstimateUtils.isPhone(phone)){
                throw new DeveloperCenterException("手机号格式不正确");
            }
            if(!ParamEstimateUtils.isEmail(registerEmail)){
                throw new DeveloperCenterException("邮箱格式不正确");
            }
            if(StringUtils.isEmpty(phoneCode)){
                throw new DeveloperCenterException("请获取短信验证码");
            }
            if(StringUtils.isEmpty(emailCode)){
                throw new DeveloperCenterException("请获取邮箱验证码");
            }
        }
    }

    public Long getDeveloperId() {
        return developerId;
    }

    public void setDeveloperId(Long developerId) {
        this.developerId = developerId;
    }

    public String getCashType() {
        return cashType;
    }

    public void setCashType(String cashType) {
        this.cashType = cashType;
    }

    public String getBusinessLicencePic() {
        return businessLicencePic;
    }

    public void setBusinessLicencePic(String businessLicencePic) {
        this.businessLicencePic = businessLicencePic;
    }

    public String getIdCardFrontPic() {
        return idCardFrontPic;
    }

    public void setIdCardFrontPic(String idCardFrontPic) {
        this.idCardFrontPic = idCardFrontPic;
    }

    public String getIdCardBackPic() {
        return idCardBackPic;
    }

    public void setIdCardBackPic(String idCardBackPic) {
        this.idCardBackPic = idCardBackPic;
    }

    public String getBank() {
        return bank;
    }

    public void setBank(String bank) {
        this.bank = bank;
    }

    public String getBankProvince() {
        return bankProvince;
    }

    public void setBankProvince(String bankProvince) {
        this.bankProvince = bankProvince;
    }

    public String getBankCity() {
        return bankCity;
    }

    public void setBankCity(String bankCity) {
        this.bankCity = bankCity;
    }

    public String getBankBranchName() {
        return bankBranchName;
    }

    public void setBankBranchName(String bankBranchName) {
        this.bankBranchName = bankBranchName;
    }

    public String getBankAccountNumber() {
        return bankAccountNumber;
    }

    public void setBankAccountNumber(String bankAccountNumber) {
        this.bankAccountNumber = bankAccountNumber;
    }

    public String getBankAccountName() {
        return bankAccountName;
    }

    public void setBankAccountName(String bankAccountName) {
        this.bankAccountName = bankAccountName;
    }

    public String getAlipayAccountNumber() {
        return alipayAccountNumber;
    }

    public void setAlipayAccountNumber(String alipayAccountNumber) {
        this.alipayAccountNumber = alipayAccountNumber;
    }

    public String getAlipayAccountName() {
        return alipayAccountName;
    }

    public void setAlipayAccountName(String alipayAccountName) {
        this.alipayAccountName = alipayAccountName;
    }

    public String getRegisterEmail() {
        return registerEmail;
    }

    public void setRegisterEmail(String registerEmail) {
        this.registerEmail = registerEmail;
    }

    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getMoney() {
        return money;
    }

    public void setMoney(String money) {
        this.money = money;
    }

    public Long getAuditId() {
        return auditId;
    }

    public void setAuditId(Long auditId) {
        this.auditId = auditId;
    }

    public String getPhoneCode() {
        return phoneCode;
    }

    public void setPhoneCode(String phoneCode) {
        this.phoneCode = phoneCode;
    }

    public String getEmailCode() {
        return emailCode;
    }

    public void setEmailCode(String emailCode) {
        this.emailCode = emailCode;
    }

    public String getNatureType() {
        return natureType;
    }

    public void setNatureType(String natureType) {
        this.natureType = natureType;
    }

    public String getToken() {
        return token;
    }

    public void setToken(String token) {
        this.token = token;
    }

}
