package cn.com.duiba.developer.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.developer.center.api.domain.dto.url.DomainAppDto;
import cn.com.duiba.developer.center.api.domain.dto.url.DomainGroupDto;

import java.util.List;

@AdvancedFeignClient
public interface RemoteDomainService {
    /**
     * 查询列表
     * @param pageNum
     * @param pageSize
     * @return
     */
    List<DomainGroupDto> findDomainGroups(Integer pageNum, Integer pageSize);

    /**
     * 查询分组内app
     * @param groupId
     * @return
     */
    List<DomainAppDto> findAppByGroupIds(Long groupId);

    /**
     * 新增域名组
     * @param domainGroupDto
     * @return
     */
    boolean insertGroup(DomainGroupDto domainGroupDto);

    /**
     * 更新域名组
     * @param domainGroupDto
     * @return
     */
    boolean updateGroup(DomainGroupDto domainGroupDto);

    /**
     * 删除域名组
     * @param groupId
     * @return
     */
    boolean deleteGroup(Long groupId);

    /**
     * 分组新增app
     * @param groupId
     * @param appId
     * @return
     */
    boolean saveOrUpdateApp(Long groupId,Long appId);
}
