package cn.com.duiba.developer.center.api.remoteservice.authority;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.developer.center.api.domain.dto.authority.ResourcesDto;
import cn.com.duiba.developer.center.api.domain.enums.authority.RightBusinessTypeEnum;
import cn.com.duiba.developer.center.api.domain.param.authority.ResourcesDetailDto;
import cn.com.duiba.developer.center.api.domain.param.authority.VersionResourceDto;
import cn.com.duiba.developer.center.api.domain.param.platform.SyncActivityParam;

import java.util.List;
import java.util.Map;

@AdvancedFeignClient
public interface RemoteResourcesService {


    /**
     * @Desc 新增
     * @params
     */
    Long save(ResourcesDto resourcesDto);


    /**
     * @Desc 根据名称 业务标签查询
     * @params
     */
    List<ResourcesDto> selectByNameAndTagId(String resourceName, RightBusinessTypeEnum rightBusinessTypeEnum);

    /**
     * @Desc 获取权限配置
     * @params VerisonAppInfoDto
     */
    List<ResourcesDetailDto> getNewResourceTagDtos();

    /**
     * @Desc 判断用户是否有购物车权限
     * @params VerisonAppInfoDto
     */
    Boolean accessNewVersionAuthorityShoppingCart(Long appId);


    /**
     * 获取app 开通的版本资源信息
     *
     * @param appId
     * @return key: 1 版本 2 零售包
     */
    List<VersionResourceDto> versionResourceInfo(Long appId);

    /**
     * 同步活动平台的活动权限信息
     *
     * @return
     */
    Boolean syncActivityPlatformResource(SyncActivityParam syncActivityParam) throws BizException;

    /**
     * 是否同步成功
     *
     * @param activityTemplateName 活动模版名称
     * @return
     */
    Boolean syncResourceResult(String activityTemplateName);
}
