package cn.com.duiba.developer.center.api.domain.enums.saas;

import cn.com.duiba.developer.center.api.DeveloperCenterException;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by zyj on 2018/5/18.
 */
public enum AccountStateEnum {
    /**
     * 账户状态
     * auditStatus
     */
    NORMAL(1,"正常"),
    FROZEN(2,"冻结");

    private static final Map<Integer, AccountStateEnum> enumMap = new HashMap<>();
    static{
        for(AccountStateEnum accountStateEnum : values()){
            enumMap.put(accountStateEnum.getValue(), accountStateEnum);
        }
    }

    public static AccountStateEnum getByCode(Integer code){
        AccountStateEnum accountStateEnum = enumMap.get(code);
        if(accountStateEnum == null){
            throw new DeveloperCenterException("不支持的状态类型");
        }
        return accountStateEnum;
    }

    private int    value;
    private String desc;

    AccountStateEnum(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public int getValue() {
        return value;
    }

    public String getDesc() {
        return desc;
    }

}
